/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.nr;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class JapanesePersonDictionary {
    static String path = HanLP.Config.JapanesePersonDictionaryPath;
    static DoubleArrayTrie<Character> trie;
    public static final char X = 'x';
    public static final char M = 'm';
    public static final char A = 'A';

    static boolean load() {
        trie = new DoubleArrayTrie();
        if (JapanesePersonDictionary.loadDat()) {
            return true;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            TreeMap<String, Character> map = new TreeMap<String, Character>();
            while ((line = br.readLine()) != null) {
                String[] param = line.split(" ", 2);
                map.put(param[0], Character.valueOf(param[1].charAt(0)));
            }
            br.close();
            Predefine.logger.info("\u65e5\u672c\u4eba\u540d\u8bcd\u5178" + path + "\u5f00\u59cb\u6784\u5efa\u53cc\u6570\u7ec4\u2026\u2026");
            trie.build(map);
            Predefine.logger.info("\u65e5\u672c\u4eba\u540d\u8bcd\u5178" + path + "\u5f00\u59cb\u7f16\u8bd1DAT\u6587\u4ef6\u2026\u2026");
            Predefine.logger.info("\u65e5\u672c\u4eba\u540d\u8bcd\u5178" + path + "\u7f16\u8bd1\u7ed3\u679c\uff1a" + JapanesePersonDictionary.saveDat(map));
        }
        catch (Exception e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        return true;
    }

    static boolean saveDat(TreeMap<String, Character> map) {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(IOUtil.newOutputStream(path + ".value.dat")));
            out.writeInt(map.size());
            for (Character character : map.values()) {
                out.writeChar(character.charValue());
            }
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u503c" + path + ".value.dat" + "\u5931\u8d25" + e);
            return false;
        }
        return trie.save(path + ".trie.dat");
    }

    static boolean loadDat() {
        ByteArray byteArray = ByteArray.createByteArray(path + ".value.dat");
        if (byteArray == null) {
            return false;
        }
        int size = byteArray.nextInt();
        Character[] valueArray = new Character[size];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = Character.valueOf(byteArray.nextChar());
        }
        return trie.load(path + ".trie.dat", (Character[])valueArray);
    }

    public static boolean containsKey(String key) {
        return trie.containsKey(key);
    }

    public static boolean containsKey(String key, int length) {
        if (!trie.containsKey(key)) {
            return false;
        }
        return key.length() >= length;
    }

    public static Character get(String key) {
        return trie.get(key);
    }

    public static DoubleArrayTrie.LongestSearcher getSearcher(char[] charArray) {
        return trie.getLongestSearcher(charArray, 0);
    }

    static {
        long start = System.currentTimeMillis();
        if (!JapanesePersonDictionary.load()) {
            throw new IllegalArgumentException("\u65e5\u672c\u4eba\u540d\u8bcd\u5178" + path + "\u52a0\u8f7d\u5931\u8d25");
        }
        Predefine.logger.info("\u65e5\u672c\u4eba\u540d\u8bcd\u5178" + HanLP.Config.PinyinDictionaryPath + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    public static class Searcher
    extends BaseSearcher<Character> {
        int begin;
        DoubleArrayTrie<Character> trie;

        protected Searcher(char[] c, DoubleArrayTrie<Character> trie) {
            super(c);
            this.trie = trie;
        }

        protected Searcher(String text, DoubleArrayTrie<Character> trie) {
            super(text);
            this.trie = trie;
        }

        @Override
        public Map.Entry<String, Character> next() {
            Map.Entry<String, Character> result = null;
            while (this.begin < this.c.length) {
                LinkedList<Map.Entry<String, Character>> entryList = this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                if (entryList.size() == 0) {
                    ++this.begin;
                    continue;
                }
                result = entryList.getLast();
                this.offset = this.begin;
                this.begin += result.getKey().length();
                break;
            }
            if (result == null) {
                return null;
            }
            return result;
        }
    }
}

