/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.nodes;

import org.htmlparser.Text;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodes.AbstractNode;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class TextNode
extends AbstractNode
implements Text {
    protected String mText;

    public TextNode(String text) {
        super(null, 0, 0);
        this.setText(text);
    }

    public TextNode(Page page, int start, int end) {
        super(page, start, end);
        this.mText = null;
    }

    public String getText() {
        return this.toHtml();
    }

    public void setText(String text) {
        this.mText = text;
        this.nodeBegin = 0;
        this.nodeEnd = this.mText.length();
    }

    public String toPlainTextString() {
        return this.toHtml();
    }

    public String toHtml() {
        String ret = this.mText;
        if (null == ret) {
            ret = this.mPage.getText(this.getStartPosition(), this.getEndPosition());
        }
        return ret;
    }

    public String toString() {
        int startpos = this.getStartPosition();
        int endpos = this.getEndPosition();
        StringBuffer ret = new StringBuffer(endpos - startpos + 20);
        if (null == this.mText) {
            Cursor start = new Cursor(this.getPage(), startpos);
            Cursor end = new Cursor(this.getPage(), endpos);
            ret.append("Txt (");
            ret.append(start);
            ret.append(",");
            ret.append(end);
            ret.append("): ");
            while (start.getPosition() < endpos) {
                try {
                    char c = this.mPage.getCharacter(start);
                    switch (c) {
                        case '\t': {
                            ret.append("\\t");
                            break;
                        }
                        case '\n': {
                            ret.append("\\n");
                            break;
                        }
                        case '\r': {
                            ret.append("\\r");
                            break;
                        }
                        default: {
                            ret.append(c);
                            break;
                        }
                    }
                }
                catch (ParserException pe) {
                    // empty catch block
                }
                if (77 > ret.length()) continue;
                ret.append("...");
                break;
            }
        } else {
            ret.append("Txt (");
            ret.append(startpos);
            ret.append(",");
            ret.append(endpos);
            ret.append("): ");
            for (int i = 0; i < this.mText.length(); ++i) {
                char c = this.mText.charAt(i);
                switch (c) {
                    case '\t': {
                        ret.append("\\t");
                        break;
                    }
                    case '\n': {
                        ret.append("\\n");
                        break;
                    }
                    case '\r': {
                        ret.append("\\r");
                        break;
                    }
                    default: {
                        ret.append(c);
                    }
                }
                if (77 > ret.length()) continue;
                ret.append("...");
                break;
            }
        }
        return ret.toString();
    }

    public void accept(NodeVisitor visitor) {
        visitor.visitStringNode(this);
    }
}

