; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN consult (FileName)
  (m-prolog (FORMAT NIL "~{~C~}" (read-file-as-charlist FileName))))

(DEFUN m-prolog (V364)
 (LET ((Chars (explode V364)))
  (LET ((TailChars (tail Chars)))
   (LET ((RChars (reverse (tail (reverse TailChars)))))
    (LET ((ErrorStr "syntax error in Prolog here: ~%~%~{~C~}"))
     (s-prolog (compile '<horn_clauses> RChars ErrorStr)))))))

(DEFUN <horn_clauses> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<optional_whitespace> (<optional_whitespace> Stream)))
    (IF (NOT (failure? <optional_whitespace>))
     (LET ((<horn_clause> (<horn_clause> <optional_whitespace>)))
      (IF (NOT (failure? <horn_clause>))
       (LET ((<horn_clauses> (<horn_clauses> <horn_clause>)))
        (IF (NOT (failure? <horn_clauses>))
         (LIST (FIRST <horn_clauses>)
          (CONS (SECOND <horn_clause>) (SECOND <horn_clauses>)))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<optional_whitespace> (<optional_whitespace> Stream)))
    (IF (NOT (failure? <optional_whitespace>))
     (LIST (FIRST <optional_whitespace>) NIL) NIL)))))

(DEFUN <optional_whitespace> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespace> (<whitespace> Stream)))
    (IF (NOT (failure? <whitespace>))
     (LET ((<optional_whitespace> (<optional_whitespace> <whitespace>)))
      (IF (NOT (failure? <optional_whitespace>))
       (LIST (FIRST <optional_whitespace>)
        (APPEND (SECOND <whitespace>) (SECOND <optional_whitespace>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <horn_clause> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<head> (<head> Stream)))
    (IF (NOT (failure? <head>))
     (LET ((<colon-dash> (<colon-dash> <head>)))
      (IF (NOT (failure? <colon-dash>))
       (LET ((<body> (<body> <colon-dash>)))
        (IF (NOT (failure? <body>))
         (IF (AND (CONSP (FIRST <body>)) (EQL (FIRST (FIRST <body>)) #\.))
          (LIST (FIRST (LIST (REST (FIRST <body>)) (SECOND <body>)))
           (CONS (SECOND <head>) (CONS ':- (CONS (SECOND <body>) NIL))))
          NIL)
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<head> (<head> Stream)))
    (IF (NOT (failure? <head>))
     (IF (AND (CONSP (FIRST <head>)) (EQL (FIRST (FIRST <head>)) #\.))
      (LIST (FIRST (LIST (REST (FIRST <head>)) (SECOND <head>)))
       (CONS (SECOND <head>) (CONS ':- (CONS NIL NIL))))
      NIL)
     NIL)))))

(DEFUN <head> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<predicate> (<predicate> Stream)))
    (IF (NOT (failure? <predicate>))
     (IF
      (AND (CONSP (FIRST <predicate>)) (EQL (FIRST (FIRST <predicate>)) #\())
      (LET
       ((<terms>
         (<terms> (LIST (REST (FIRST <predicate>)) (SECOND <predicate>)))))
       (IF (NOT (failure? <terms>))
        (IF (AND (CONSP (FIRST <terms>)) (EQL (FIRST (FIRST <terms>)) #\)))
         (LIST (FIRST (LIST (REST (FIRST <terms>)) (SECOND <terms>)))
          (CONS (SECOND <predicate>) (SECOND <terms>)))
         NIL)
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<predicate> (<predicate> Stream)))
    (IF (NOT (failure? <predicate>))
     (LIST (FIRST <predicate>) (CONS (SECOND <predicate>) NIL)) NIL)))))

(DEFUN <colon-dash> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (IF
      (AND (CONSP (FIRST <whitespaces>))
       (EQL (FIRST (FIRST <whitespaces>)) #\:))
      (IF
       (AND
        (CONSP
         (FIRST (LIST (REST (FIRST <whitespaces>)) (SECOND <whitespaces>))))
        (EQL
         (FIRST
          (FIRST (LIST (REST (FIRST <whitespaces>)) (SECOND <whitespaces>))))
         #\-))
       (LIST
        (FIRST
         (LIST
          (REST
           (FIRST (LIST (REST (FIRST <whitespaces>)) (SECOND <whitespaces>))))
          (SECOND (LIST (REST (FIRST <whitespaces>)) (SECOND <whitespaces>)))))
        (APPEND (SECOND <whitespaces>) (CONS #\: (CONS #\- NIL))))
       NIL)
      NIL)
     NIL)))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\:))
    (IF
     (AND (CONSP (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
      (EQL (FIRST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))) #\-))
     (LIST
      (FIRST
       (LIST (REST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
        (SECOND (LIST (REST (FIRST Stream)) (SECOND Stream)))))
      (CONS #\: (CONS #\- NIL)))
     NIL)
    NIL))))

(DEFUN <body> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<literal> (<literal> Stream)))
    (IF (NOT (failure? <literal>))
     (LET ((<comma> (<comma> <literal>)))
      (IF (NOT (failure? <comma>))
       (LET ((<body> (<body> <comma>)))
        (IF (NOT (failure? <body>))
         (LIST (FIRST <body>) (CONS (SECOND <literal>) (SECOND <body>))) NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<literal> (<literal> Stream)))
    (IF (NOT (failure? <literal>))
     (LIST (FIRST <literal>) (CONS (SECOND <literal>) NIL)) NIL)))))

(DEFUN <literal> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<variable> (<variable> Stream)))
    (IF (NOT (failure? <variable>))
     (LET ((<is> (<is> <variable>)))
      (IF (NOT (failure? <is>))
       (LET ((<tterm> (<tterm> <is>)))
        (IF (NOT (failure? <tterm>))
         (LIST (FIRST <tterm>)
          (CONS 'is (CONS (SECOND <variable>) (CONS (SECOND <tterm>) NIL))))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<predicate> (<predicate> Stream)))
    (IF (NOT (failure? <predicate>))
     (IF
      (AND (CONSP (FIRST <predicate>)) (EQL (FIRST (FIRST <predicate>)) #\())
      (LET
       ((<tterms>
         (<tterms> (LIST (REST (FIRST <predicate>)) (SECOND <predicate>)))))
       (IF (NOT (failure? <tterms>))
        (IF (AND (CONSP (FIRST <tterms>)) (EQL (FIRST (FIRST <tterms>)) #\)))
         (LIST (FIRST (LIST (REST (FIRST <tterms>)) (SECOND <tterms>)))
          (CONS (SECOND <predicate>) (SECOND <tterms>)))
         NIL)
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<predicate> (<predicate> Stream)))
    (IF (NOT (failure? <predicate>))
     (LIST (FIRST <predicate>) (CONS (SECOND <predicate>) NIL)) NIL)))))

(DEFUN insert-deref (V35)
 (COND ((wrapper (variable? V35)) (CONS 'deref (CONS V35 NIL)))
  ((CONSP V35) (CONS (insert-deref (CAR V35)) (insert-deref (CDR V35))))
  (T V35)))

(DEFUN <variable> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (LET ((<variable> (<variable> <whitespaces>)))
      (IF (NOT (failure? <variable>)) <variable> NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<token> (<token> Stream)))
    (IF (NOT (failure? <token>))
     (LIST (FIRST <token>)
      (if (variable? (tokenise (SECOND <token>))) (tokenise (SECOND <token>))
       (RETURN-FROM localfailure NIL)))
     NIL)))))

(DEFUN <is> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (LET ((<is> (<is> <whitespaces>)))
      (IF (NOT (failure? <is>))
       (LIST (FIRST <is>) (APPEND (SECOND <whitespaces>) (SECOND <is>))) NIL))
     NIL)))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\i))
    (IF
     (AND (CONSP (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
      (EQL (FIRST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))) #\s))
     (LIST
      (FIRST
       (LIST (REST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
        (SECOND (LIST (REST (FIRST Stream)) (SECOND Stream)))))
      (CONS #\i (CONS #\s NIL)))
     NIL)
    NIL))))

(DEFUN <predicate> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (LET ((<lowercase> (<lowercase> <whitespaces>)))
      (IF (NOT (failure? <lowercase>)) <lowercase> NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<lowercase> (<lowercase> Stream)))
    (IF (NOT (failure? <lowercase>)) <lowercase> NIL)))))

(DEFUN <lowercase> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<lcase> (<lcase> Stream)))
    (IF (NOT (failure? <lcase>))
     (LET ((<symbols> (<symbols> <lcase>)))
      (IF (NOT (failure? <symbols>))
       (LIST (FIRST <symbols>)
        (tokenise (CONS (SECOND <lcase>) (SECOND <symbols>))))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<lcase> (<lcase> Stream)))
    (IF (NOT (failure? <lcase>))
     (LIST (FIRST <lcase>) (tokenise (CONS (SECOND <lcase>) NIL))) NIL)))))

(DEFUN <lcase> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (IF
      (OR (UPPER-CASE-P (CAAR Stream))
       (MEMBER (CAAR Stream)
        '(#\. #\; #\, #\| #\( #\) #\[ #\] #\: #\Space #\Newline #\Tab #\Return
          #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9 #\0)
        :TEST 'CHAR-EQUAL))
      (RETURN-FROM localfailure NIL) (CAAR Stream)))
    NIL))))

(DEFUN <symbols> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<symbol> (<symbol> Stream)))
    (IF (NOT (failure? <symbol>))
     (LET ((<symbols> (<symbols> <symbol>)))
      (IF (NOT (failure? <symbols>))
       (LIST (FIRST <symbols>) (CONS (SECOND <symbol>) (SECOND <symbols>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<symbol> (<symbol> Stream)))
    (IF (NOT (failure? <symbol>))
     (LIST (FIRST <symbol>) (CONS (SECOND <symbol>) NIL)) NIL)))))

(DEFUN <symbol> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (IF
      (MEMBER (CAAR Stream) '(#\. #\; #\, #\| #\( #\) #\[ #\] #\: #\Space #\Newline #\Tab #\Return) :TEST 'CHAR-EQUAL)
      (RETURN-FROM localfailure NIL) (CAAR Stream)))
    NIL))))

(DEFUN <terms> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<term1> (<term1> Stream)))
    (IF (NOT (failure? <term1>))
     (LET ((<bar> (<bar> <term1>)))
      (IF (NOT (failure? <bar>))
       (LET ((<term2> (<term2> <bar>)))
        (IF (NOT (failure? <term2>))
         (LIST (FIRST <term2>) (CONS (SECOND <term1>) (SECOND <term2>))) NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<term> (<term> Stream)))
    (IF (NOT (failure? <term>))
     (LET ((<comma> (<comma> <term>)))
      (IF (NOT (failure? <comma>))
       (LET ((<terms> (<terms> <comma>)))
        (IF (NOT (failure? <terms>))
         (LIST (FIRST <terms>) (CONS (SECOND <term>) (SECOND <terms>))) NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<term> (<term> Stream)))
    (IF (NOT (failure? <term>))
     (LIST (FIRST <term>) (CONS (SECOND <term>) NIL)) NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <term> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (LET ((<term> (<term> <whitespaces>)))
      (IF (NOT (failure? <term>)) <term> NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<token> (<token> Stream)))
    (IF (NOT (failure? <token>))
     (LIST (FIRST <token>) (tokenise (SECOND <token>))) NIL)))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\[))
    (LET ((<terms> (<terms> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <terms>))
      (IF (AND (CONSP (FIRST <terms>)) (EQL (FIRST (FIRST <terms>)) #\]))
       (LIST (FIRST (LIST (REST (FIRST <terms>)) (SECOND <terms>)))
        (SECOND <terms>))
       NIL)
      NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\())
    (LET ((<terms> (<terms> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <terms>))
      (IF (AND (CONSP (FIRST <terms>)) (EQL (FIRST (FIRST <terms>)) #\)))
       (LIST (FIRST (LIST (REST (FIRST <terms>)) (SECOND <terms>)))
        (insert_modes (SECOND <terms>)))
       NIL)
      NIL))
    NIL))))

(DEFUN insert_modes (V1)
 (COND
  ((AND (CONSP V1) (EQ 'mode (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (NULL (CDR (CDR (CDR V1)))))
   V1)
  ((NULL V1) NIL)
  ((CONSP V1) (LIST (LIST 'mode (CAR V1) '+) 'mode (insert_modes (CDR V1)) '-))
  (T V1)))

(DEFUN <term1> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<term> (<term> Stream))) (IF (NOT (failure? <term>)) <term> NIL)))))

(DEFUN <term2> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<term> (<term> Stream))) (IF (NOT (failure? <term>)) <term> NIL)))))

(DEFUN <bar> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (IF
      (AND (CONSP (FIRST <whitespaces>))
       (EQL (FIRST (FIRST <whitespaces>)) #\|))
      (LIST (FIRST (LIST (REST (FIRST <whitespaces>)) (SECOND <whitespaces>)))
       (APPEND (SECOND <whitespaces>) (CONS #\| NIL)))
      NIL)
     NIL)))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\|))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (CONS #\| NIL))
    NIL))))

(DEFUN <comma> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (IF
      (AND (CONSP (FIRST <whitespaces>))
       (EQL (FIRST (FIRST <whitespaces>)) #\,))
      (LIST (FIRST (LIST (REST (FIRST <whitespaces>)) (SECOND <whitespaces>)))
       (APPEND (SECOND <whitespaces>) (CONS #\, NIL)))
      NIL)
     NIL)))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\,))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (CONS #\, NIL))
    NIL))
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>)) <whitespaces> NIL)))))

(DEFUN <tterms> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<tterm1> (<tterm1> Stream)))
    (IF (NOT (failure? <tterm1>))
     (LET ((<bar> (<bar> <tterm1>)))
      (IF (NOT (failure? <bar>))
       (LET ((<tterm2> (<tterm2> <bar>)))
        (IF (NOT (failure? <tterm2>))
         (LIST (FIRST <tterm2>)
          (LIST (SECOND <tterm1>) 'bar# (SECOND <tterm2>)))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<tterm> (<tterm> Stream)))
    (IF (NOT (failure? <tterm>))
     (LET ((<comma> (<comma> <tterm>)))
      (IF (NOT (failure? <comma>))
       (LET ((<tterms> (<tterms> <comma>)))
        (IF (NOT (failure? <tterms>))
         (LIST (FIRST <tterms>) (CONS (SECOND <tterm>) (SECOND <tterms>)))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<tterm> (<tterm> Stream)))
    (IF (NOT (failure? <tterm>))
     (LIST (FIRST <tterm>) (CONS (SECOND <tterm>) NIL)) NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <tterm1> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<tterm> (<tterm> Stream)))
    (IF (NOT (failure? <tterm>)) <tterm> NIL)))))

(DEFUN <tterm2> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<tterm> (<tterm> Stream)))
    (IF (NOT (failure? <tterm>)) <tterm> NIL)))))

(DEFUN <tterm> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (LET ((<tterm> (<tterm> <whitespaces>)))
      (IF (NOT (failure? <tterm>)) <tterm> NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<token> (<token> Stream)))
    (IF (NOT (failure? <token>))
     (LIST (FIRST <token>) (tokenise (SECOND <token>))) NIL)))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\[))
    (LET ((<tterms> (<tterms> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <tterms>))
      (IF (AND (CONSP (FIRST <tterms>)) (EQL (FIRST (FIRST <tterms>)) #\]))
       (LIST (FIRST (LIST (REST (FIRST <tterms>)) (SECOND <tterms>)))
        (cons_form (SECOND <tterms>)))
       NIL)
      NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\())
    (LET ((<tterms> (<tterms> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <tterms>))
      (IF (AND (CONSP (FIRST <tterms>)) (EQL (FIRST (FIRST <tterms>)) #\)))
       (LIST (FIRST (LIST (REST (FIRST <tterms>)) (SECOND <tterms>)))
        (SECOND <tterms>))
       NIL)
      NIL))
    NIL))))

(DEFUN s-prolog (V1)
 (THE LIST
  (MAPCAR 'compile-prolog-procedure
   (group-clauses
    (THE LIST (MAPCAR 's-prolog-clause (mapcan 'head-abstraction V1)))))))

(DEFUN mapcan (V55 V56)
 (COND ((NULL V56) NIL)
  ((CONSP V56) (APPEND (apply V55 (CAR V56)) (mapcan V55 (CDR V56))))
  (T (ERROR "mapcan expects a list"))))

(DEFUN head-abstraction (V572)
 (COND
  ((AND (CONSP V572) (CONSP (CDR V572)) (EQ ':- (CAR (CDR V572)))
    (CONSP (CDR (CDR V572))) (NULL (CDR (CDR (CDR V572))))
    (< (complexity-head (CAR V572)) *maxcomplexity*))
   (CONS (CONS (CAR V572) (CONS ':- (CONS (CAR (CDR (CDR V572))) NIL))) NIL))
  ((AND (CONSP V572) (CONSP (CAR V572)) (CONSP (CDR V572))
    (EQ ':- (CAR (CDR V572))) (CONSP (CDR (CDR V572)))
    (NULL (CDR (CDR (CDR V572)))))
   (LET ((Terms (MAPCAR #'(LAMBDA (Y) (gensym "X")) (CDR (CAR V572)))))
    (LET ((XTerms (walk_cons_form (remove_modes (CDR (CAR V572))))))
     (LET ((Literal (CONS 'unify (CONS (cons_form Terms) (CONS XTerms NIL)))))
      (LET
       ((Clause
         (CONS (CONS (CAR (CAR V572)) Terms)
          (CONS ':- (CONS (CONS Literal (CAR (CDR (CDR V572)))) NIL)))))
       (CONS Clause NIL))))))
  (T (implementation_error 'head-abstraction))))

(SETQ *maxcomplexity* 128)

(DEFUN complexity-head (V14)
 (COND ((CONSP V14) (product (THE LIST (MAPCAR 'complexity (CDR V14)))))
  (T (implementation_error 'complexity-head))))

(DEFUN complexity (V24)
 (COND
  ((AND (CONSP V24) (EQ 'mode (CAR V24)) (CONSP (CDR V24))
    (CONSP (CAR (CDR V24))) (EQ 'mode (CAR (CAR (CDR V24))))
    (CONSP (CDR (CAR (CDR V24)))) (CONSP (CDR (CDR (CAR (CDR V24)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V24)))))) (CONSP (CDR (CDR V24)))
    (NULL (CDR (CDR (CDR V24)))))
   (complexity (CAR (CDR V24))))
  ((AND (CONSP V24) (EQ 'mode (CAR V24)) (CONSP (CDR V24))
    (CONSP (CAR (CDR V24))) (CONSP (CDR (CDR V24)))
    (EQ '+ (CAR (CDR (CDR V24)))) (NULL (CDR (CDR (CDR V24)))))
   (LET* ((V25 (CDR V24)) (V26 (CAR V25)) (V27 (CDR V25)))
    (THE NUMBER
     (* 2 (complexity (CONS 'mode (CONS (CAR V26) V27)))
      (complexity (CONS 'mode (CONS (CDR V26) V27)))))))
  ((AND (CONSP V24) (EQ 'mode (CAR V24)) (CONSP (CDR V24))
    (CONSP (CAR (CDR V24))) (CONSP (CDR (CDR V24)))
    (EQ '- (CAR (CDR (CDR V24)))) (NULL (CDR (CDR (CDR V24)))))
   (LET* ((V28 (CDR V24)) (V29 (CAR V28)) (V30 (CDR V28)))
    (THE NUMBER
     (* (complexity (CONS 'mode (CONS (CAR V29) V30)))
      (complexity (CONS 'mode (CONS (CDR V29) V30)))))))
  ((AND (CONSP V24) (EQ 'mode (CAR V24)) (CONSP (CDR V24))
    (CONSP (CDR (CDR V24))) (NULL (CDR (CDR (CDR V24))))
    (wrapper (variable? (CAR (CDR V24)))))
   1)
  ((AND (CONSP V24) (EQ 'mode (CAR V24)) (CONSP (CDR V24))
    (CONSP (CDR (CDR V24))) (EQ '+ (CAR (CDR (CDR V24))))
    (NULL (CDR (CDR (CDR V24)))))
   2)
  ((AND (CONSP V24) (EQ 'mode (CAR V24)) (CONSP (CDR V24))
    (CONSP (CDR (CDR V24))) (EQ '- (CAR (CDR (CDR V24))))
    (NULL (CDR (CDR (CDR V24)))))
   1)
  (T (complexity (LIST 'mode V24 '+)))))

(DEFUN product (V31)
 (COND ((NULL V31) 1)
  ((CONSP V31) (THE NUMBER (* (CAR V31) (product (CDR V31)))))
  (T (implementation_error 'product))))

(DEFUN s-prolog-clause (V1)
 (COND
  ((AND (CONSP V1) (CONSP (CDR V1)) (EQ ':- (CAR (CDR V1)))
    (CONSP (CDR (CDR V1))) (NULL (CDR (CDR (CDR V1)))))
   (LIST (CAR V1) ':- (THE LIST (map 's-prolog-literal (CAR (CDR (CDR V1)))))))
  (T (implementation_error 's-prolog-clause))))

(DEFUN s-prolog-literal (V1)
 (COND
  ((AND (CONSP V1) (EQ 'is (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (NULL (CDR (CDR (CDR V1)))))
   (LET* ((V2 (CDR V1))) (LIST 'is (CAR V2) (insert-deref (CAR (CDR V2))))))
  ((AND (CONSP V1) (EQ 'when (CAR V1)) (CONSP (CDR V1)) (NULL (CDR (CDR V1))))
   (LIST 'when (insert-deref (CAR (CDR V1)))))
  ((CONSP V1) (CONS (m-prolog->s-prolog-predicate (CAR V1)) (CDR V1)))
  (T (implementation_error 's-prolog-literal))))

(DEFUN m-prolog->s-prolog-predicate (V3)
 (COND ((EQ 'qi_= V3) 'unify) 
       ((EQ '= V3) 'unify) 
       ((EQ '=! V3) 'unify!) 
       ((EQ '== V3) 'identical)
       (T V3)))

(DEFUN group-clauses (V4)
 (COND ((NULL V4) NIL)
  ((CONSP V4)
   (LET ((Group (collect #'(LAMBDA (X) (same-predicate? (CAR V4) X)) V4)))
    (LET ((Rest (difference V4 Group))) (CONS Group (group-clauses Rest)))))
  (T (implementation_error 'group-clauses))))

(DEFUN collect (V7 V8)
 (COND ((NULL V8) NIL)
  ((CONSP V8)
   (LET* ((V9 (CAR V8)) (V10 (CDR V8)))
    (if (apply V7 V9) (CONS V9 (collect V7 V10)) (collect V7 V10))))
  (T (implementation_error 'collect))))

(DEFUN same-predicate? (V29 V30)
 (COND
  ((AND (CONSP V29) (CONSP (CAR V29)) (CONSP V30) (CONSP (CAR V30)))
   (qi_= (CAR (CAR V29)) (CAR (CAR V30))))
  (T (implementation_error 'same-predicate?))))

(DEFUN compile-prolog-procedure (V31)
 (LET ((F (procedure-name V31)))
  (LET ((Source (clauses->lisp F V31)))
   (LET ((Record (record_source F Source))) (COMPILE (EVAL Source))))))

(DEFUN procedure-name (V44)
 (COND
  ((AND (CONSP V44) (CONSP (CAR V44)) (CONSP (CAR (CAR V44))))
   (CAR (CAR (CAR V44))))
  (T (implementation_error 'procedure-name))))

(DEFUN clauses->lisp (V45 V46)
 (LET ((Linear (MAPCAR 'linearise-clause V46)))
  (LET ((Arity (prolog-aritycheck V45 (MAPCAR 'head V46))))
   (LET ((Parameters (parameters Arity)))
    (LET ((AUM-instructions (MAPCAR #'(LAMBDA (X) (aum X Parameters)) Linear)))
     (LET ((LispCode (MAPCAR 'aum->lisp AUM-instructions)))
      (LET ((Block (block LispCode)))
       (LET
        ((Lisp (LIST 'DEFUN V45 (APPEND Parameters (LIST 'Continuation)) Block)))
        Lisp))))))))

(DEFUN block (V4)
 (COND ((AND (CONSP V4) (NULL (CDR V4))) (CONS 'BLOCK (CONS 'failure V4)))
  (T (LIST 'BLOCK 'failure (CONS 'OR V4)))))

(DEFUN prolog-aritycheck (V50 V51)
 (COND ((AND (CONSP V51) (NULL (CDR V51))) (1- (LIST-LENGTH (CAR V51))))
  ((AND (CONSP V51) (CONSP (CDR V51)))
   (LET* ((V52 (CDR V51)))
    (if (qi_= (LIST-LENGTH (CAR V51)) (LIST-LENGTH (CAR V52)))
     (prolog-aritycheck V50 V52)
     (error "arity error in prolog procedure ~A~%" V50))))
  (T (implementation_error 'prolog-aritycheck))))

(DEFUN linearise-clause (V53)
 (COND
  ((AND (CONSP V53) (CONSP (CDR V53)) (EQ ':- (CAR (CDR V53)))
    (CONSP (CDR (CDR V53))) (NULL (CDR (CDR (CDR V53)))))
   (LET ((Linear (linearise (CONS (CAR V53) (CDR (CDR V53))))))
    (clause-form Linear)))
  (T (implementation_error 'linearise-clause))))

(DEFUN clause-form (V1747)
 (COND
  ((AND (CONSP V1747) (CONSP (CDR V1747)) (NULL (CDR (CDR V1747))))
   (CONS (explicit-modes (CAR V1747))
    (CONS ':- (CONS (cf-help (CAR (CDR V1747))) NIL))))
  (T (implementation_error 'clause-form))))

(DEFUN explicit-modes (V1752)
 (COND ((CONSP V1752) (CONS (CAR V1752) (MAPCAR 'em-help (CDR V1752))))
  (T (implementation_error 'explicit-modes))))

(DEFUN em-help (V1749)
 (COND
  ((AND (CONSP V1749) (EQ 'mode (CAR V1749)) (CONSP (CDR V1749))
    (CONSP (CDR (CDR V1749))) (NULL (CDR (CDR (CDR V1749)))))
   V1749)
  (T (CONS 'mode (CONS V1749 (CONS '+ NIL))))))

(DEFUN cf-help (V55)
 (COND
  ((AND (CONSP V55) (EQ 'where (CAR V55)) (CONSP (CDR V55))
    (CONSP (CAR (CDR V55))) (EQ 'qi_= (CAR (CAR (CDR V55))))
    (CONSP (CDR (CAR (CDR V55)))) (CONSP (CDR (CDR (CAR (CDR V55)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V55)))))) (CONSP (CDR (CDR V55)))
    (NULL (CDR (CDR (CDR V55)))))
   (LET* ((V56 (CDR V55)))
    (CONS (CONS (if *occurs* 'unify! 'unify) (CDR (CAR V56))) (cf-help (CAR (CDR V56))))))
  (T V55)))

(DEFUN occurs-check (Flag)
  (COND ((EQ Flag '+) (SETQ *occurs* 'true))
         ((EQ Flag '-) (SETQ *occurs* 'false))
         (T (error "occurs expects + or -~%"))))

(SETQ *occurs* 'true)

(DEFUN aum (V1 V2)
 (COND
  ((AND (CONSP V1) (CONSP (CAR V1)) (CONSP (CDR V1)) (EQ ':- (CAR (CDR V1)))
    (CONSP (CDR (CDR V1))) (NULL (CDR (CDR (CDR V1)))))
   (LET* ((V3 (CAR V1)) (V4 (CDR V3)))
    (LET
     ((MuApplication
       (make_mu_application
        (LIST 'mu V4 (continuation_call V4 (CAR (CDR (CDR V1))))) V2)))
     (mu_reduction MuApplication '+))))
  (T (implementation_error 'aum))))

(DEFUN make_mu_application (V9 V10)
 (COND
  ((AND (CONSP V9) (EQ 'mu (CAR V9)) (CONSP (CDR V9)) (NULL (CAR (CDR V9)))
    (CONSP (CDR (CDR V9))) (NULL (CDR (CDR (CDR V9)))) (NULL V10))
   (CAR (CDR (CDR V9))))
  ((AND (CONSP V9) (EQ 'mu (CAR V9)) (CONSP (CDR V9)) (CONSP (CAR (CDR V9)))
    (CONSP (CDR (CDR V9))) (NULL (CDR (CDR (CDR V9)))) (CONSP V10))
   (LET* ((V11 (CDR V9)) (V12 (CAR V11)))
    (LIST
     (LIST 'mu (CAR V12)
      (make_mu_application (CONS 'mu (CONS (CDR V12) (CDR V11))) (CDR V10)))
     (CAR V10))))
  (T (implementation_error 'make_mu_application))))

(DEFUN continuation_call (V5 V6)
 (LET ((VTerms (extract-vars V5)))
  (LET ((VBody (extract-vars V6)))
   (LET ((Free (difference VBody VTerms))) (cc-help Free V6)))))

(DEFUN cc-help (V7 V8)
 (COND ((AND (NULL V7) (NULL V8)) (LIST 'pop 'the 'stack))
  ((NULL V8)
   (LIST 'rename 'the 'variables 'in V7 'and 'then (LIST 'pop 'the 'stack)))
  ((NULL V7) (LIST 'call 'the 'continuation V8))
  (T
   (LIST 'rename 'the 'variables 'in V7 'and 'then
    (LIST 'call 'the 'continuation V8)))))

(DEFUN mu_reduction (V7 V8)
 (COND
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CAR (CDR (CAR V7))))
    (EQ 'mode (CAR (CAR (CDR (CAR V7))))) (CONSP (CDR (CAR (CDR (CAR V7)))))
    (CONSP (CDR (CDR (CAR (CDR (CAR V7))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CAR V7))))))) (CONSP (CDR (CDR (CAR V7))))
    (NULL (CDR (CDR (CDR (CAR V7))))) (CONSP (CDR V7)) (NULL (CDR (CDR V7))))
   (LET* ((V9 (CAR V7)) (V10 (CDR V9)) (V11 (CAR V10)) (V12 (CDR V11)))
    (mu_reduction (CONS (CONS 'mu (CONS (CAR V12) (CDR V10))) (CDR V7))
     (CAR (CDR V12)))))
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CDR (CDR (CAR V7))))
    (NULL (CDR (CDR (CDR (CAR V7))))) (CONSP (CDR V7)) (NULL (CDR (CDR V7)))
    (EQ '_ (CAR (CDR (CAR V7)))))
   (mu_reduction (CAR (CDR (CDR (CAR V7)))) V8))
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CDR (CDR (CAR V7))))
    (NULL (CDR (CDR (CDR (CAR V7))))) (CONSP (CDR V7)) (NULL (CDR (CDR V7)))
    (wrapper (ephemeral_variable? (CAR (CDR (CAR V7))) (CAR (CDR V7)))))
   (LET* ((V13 (CAR V7)) (V14 (CDR V13)))
    (subst (CAR (CDR V7)) (CAR V14) (mu_reduction (CAR (CDR V14)) V8))))
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CDR (CDR (CAR V7))))
    (NULL (CDR (CDR (CDR (CAR V7))))) (CONSP (CDR V7)) (NULL (CDR (CDR V7)))
    (wrapper (variable? (CAR (CDR (CAR V7))))))
   (LET* ((V15 (CAR V7)) (V16 (CDR V15)))
    (LIST 'let (CAR V16) 'be (CAR (CDR V7)) 'in
     (mu_reduction (CAR (CDR V16)) V8))))
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CDR (CDR (CAR V7))))
    (NULL (CDR (CDR (CDR (CAR V7))))) (CONSP (CDR V7)) (NULL (CDR (CDR V7)))
    (EQ '- V8) (wrapper (prolog-constant? (CAR (CDR (CAR V7))))))
   (LET* ((V17 (CAR V7)) (V18 (CDR V17)))
    (LET ((Z (gensym "X")))
     (LIST 'let Z 'be
      (CONS 'the (CONS 'result (CONS 'of (CONS 'dereferencing (CDR V7))))) 'in
      (LIST 'if (LIST Z 'is 'identical 'to (CAR V18)) 'then
       (mu_reduction (CAR (CDR V18)) '-) 'else 'fail!)))))
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CDR (CDR (CAR V7))))
    (NULL (CDR (CDR (CDR (CAR V7))))) (CONSP (CDR V7)) (NULL (CDR (CDR V7)))
    (EQ '+ V8) (wrapper (prolog-constant? (CAR (CDR (CAR V7))))))
   (LET*
    ((V19 (CAR V7)) (V20 (CDR V19)) (V21 (CAR V20)) (V22 (CDR V20))
     (V23 (CAR V22)))
    (LET ((Z (gensym "X")))
     (LIST 'let Z 'be
      (CONS 'the (CONS 'result (CONS 'of (CONS 'dereferencing (CDR V7))))) 'in
      (LIST 'if (LIST Z 'is 'identical 'to V21) 'then (mu_reduction V23 '+)
       'else
       (LIST 'if (LIST Z 'is 'a 'variable) 'then
        (LIST 'bind Z 'to V21 'in (mu_reduction V23 '+)) 'else 'fail!))))))
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CAR (CDR (CAR V7))))
    (CONSP (CDR (CDR (CAR V7)))) (NULL (CDR (CDR (CDR (CAR V7)))))
    (CONSP (CDR V7)) (NULL (CDR (CDR V7))) (EQ '- V8))
   (LET* ((V24 (CAR V7)) (V25 (CDR V24)) (V26 (CAR V25)))
    (LET ((Z (gensym "X")))
     (LIST 'let Z 'be
      (CONS 'the (CONS 'result (CONS 'of (CONS 'dereferencing (CDR V7))))) 'in
      (LIST 'if (LIST Z 'is 'a 'non-empty 'list) 'then
       (mu_reduction
        (LIST
         (LIST 'mu (CAR V26)
          (LIST (CONS 'mu (CONS (CDR V26) (CDR V25))) (LIST 'the 'tail 'of Z)))
         (LIST 'the 'head 'of Z))
        '-)
       'else 'fail!)))))
  ((AND (CONSP V7) (CONSP (CAR V7)) (EQ 'mu (CAR (CAR V7)))
    (CONSP (CDR (CAR V7))) (CONSP (CAR (CDR (CAR V7))))
    (CONSP (CDR (CDR (CAR V7)))) (NULL (CDR (CDR (CDR (CAR V7)))))
    (CONSP (CDR V7)) (NULL (CDR (CDR V7))) (EQ '+ V8))
   (LET* ((V27 (CAR V7)) (V28 (CDR V27)) (V29 (CAR V28)) (V30 (CDR V28)))
    (LET ((Z (gensym "X")))
     (LIST 'let Z 'be
      (CONS 'the (CONS 'result (CONS 'of (CONS 'dereferencing (CDR V7))))) 'in
      (LIST 'if (LIST Z 'is 'a 'non-empty 'list) 'then
       (mu_reduction
        (LIST
         (LIST 'mu (CAR V29)
          (LIST (CONS 'mu (CONS (CDR V29) V30)) (LIST 'the 'tail 'of Z)))
         (LIST 'the 'head 'of Z))
        '+)
       'else
       (LIST 'if (LIST Z 'is 'a 'variable) 'then
        (LIST 'rename 'the 'variables 'in (extract-vars V29) 'and 'then
         (LIST 'bind Z 'to (rcons_form (remove_modes V29)) 'in
          (mu_reduction (CAR V30) '+)))
        'else 'fail!))))))
  (T V7)))

(DEFUN remove_modes (V1)
 (COND
  ((AND (CONSP V1) (EQ 'mode (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (EQ '+ (CAR (CDR (CDR V1)))) (NULL (CDR (CDR (CDR V1)))))
   (remove_modes (CAR (CDR V1))))
  ((AND (CONSP V1) (EQ 'mode (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (EQ '- (CAR (CDR (CDR V1)))) (NULL (CDR (CDR (CDR V1)))))
   (remove_modes (CAR (CDR V1))))
  ((CONSP V1) (CONS (remove_modes (CAR V1)) (remove_modes (CDR V1)))) 
  (T V1)))

(DEFUN rcons_form (V32)
 (COND ((CONSP V32) (LIST 'cons (rcons_form (CAR V32)) (rcons_form (CDR V32))))
  (T V32)))

(DEFUN ephemeral_variable? (V32 V33)
 (THE SYMBOL (and (THE SYMBOL (variable? V32)) (THE SYMBOL (variable? V33)))))

(DEFUN prolog-constant? (V44) (COND ((CONSP V44) 'false) (T 'true)))

(DEFUN aum->lisp (V45)
 (COND
  ((AND (CONSP V45) (EQ 'let (CAR V45)) (CONSP (CDR V45))
    (CONSP (CDR (CDR V45))) (EQ 'be (CAR (CDR (CDR V45))))
    (CONSP (CDR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR (CDR V45)))))
    (EQ 'in (CAR (CDR (CDR (CDR (CDR V45))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR V45))))))
    (NULL (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))
   (LET* ((V46 (CDR V45)) (V47 (CDR V46)) (V48 (CDR V47)))
    (LIST 'LET (LIST (LIST (CAR V46) (aum->lisp (CAR V48))))
     (aum->lisp (CAR (CDR (CDR V48)))))))
  ((AND (CONSP V45) (EQ 'the (CAR V45)) (CONSP (CDR V45))
    (EQ 'result (CAR (CDR V45))) (CONSP (CDR (CDR V45)))
    (EQ 'of (CAR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR V45))))
    (EQ 'dereferencing (CAR (CDR (CDR (CDR V45)))))
    (CONSP (CDR (CDR (CDR (CDR V45)))))
    (NULL (CDR (CDR (CDR (CDR (CDR V45)))))))
   (LIST 'lazyderef (aum->lisp (CAR (CDR (CDR (CDR (CDR V45))))))))
  ((AND (CONSP V45) (EQ 'if (CAR V45)) (CONSP (CDR V45))
    (CONSP (CDR (CDR V45))) (EQ 'then (CAR (CDR (CDR V45))))
    (CONSP (CDR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR (CDR V45)))))
    (EQ 'else (CAR (CDR (CDR (CDR (CDR V45))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR V45))))))
    (NULL (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))
   (LET* ((V49 (CDR V45)) (V50 (CDR V49)) (V51 (CDR V50)))
    (LIST 'IF (aum->lisp (CAR V49)) (aum->lisp (CAR V51))
     (aum->lisp (CAR (CDR (CDR V51)))))))
  ((AND (CONSP V45) (CONSP (CDR V45)) (EQ 'is (CAR (CDR V45)))
    (CONSP (CDR (CDR V45))) (EQ 'a (CAR (CDR (CDR V45))))
    (CONSP (CDR (CDR (CDR V45)))) (EQ 'variable (CAR (CDR (CDR (CDR V45)))))
    (NULL (CDR (CDR (CDR (CDR V45))))))
   (LIST 'var? (CAR V45)))
  ((AND (CONSP V45) (CONSP (CDR V45)) (EQ 'is (CAR (CDR V45)))
    (CONSP (CDR (CDR V45))) (EQ 'a (CAR (CDR (CDR V45))))
    (CONSP (CDR (CDR (CDR V45)))) (EQ 'non-empty (CAR (CDR (CDR (CDR V45)))))
    (CONSP (CDR (CDR (CDR (CDR V45)))))
    (EQ 'list (CAR (CDR (CDR (CDR (CDR V45))))))
    (NULL (CDR (CDR (CDR (CDR (CDR V45)))))))
   (LIST 'CONSP (CAR V45)))
  ((AND (CONSP V45) (EQ 'rename (CAR V45)) (CONSP (CDR V45))
    (EQ 'the (CAR (CDR V45))) (CONSP (CDR (CDR V45)))
    (EQ 'variables (CAR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR V45))))
    (EQ 'in (CAR (CDR (CDR (CDR V45))))) (CONSP (CDR (CDR (CDR (CDR V45)))))
    (NULL (CAR (CDR (CDR (CDR (CDR V45))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR V45))))))
    (EQ 'and (CAR (CDR (CDR (CDR (CDR (CDR V45)))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR (CDR V45)))))))
    (EQ 'then (CAR (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))
    (NULL (CDR (CDR (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))))
   (aum->lisp (CAR (CDR (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))))
  ((AND (CONSP V45) (EQ 'rename (CAR V45)) (CONSP (CDR V45))
    (EQ 'the (CAR (CDR V45))) (CONSP (CDR (CDR V45)))
    (EQ 'variables (CAR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR V45))))
    (EQ 'in (CAR (CDR (CDR (CDR V45))))) (CONSP (CDR (CDR (CDR (CDR V45)))))
    (CONSP (CAR (CDR (CDR (CDR (CDR V45))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR V45))))))
    (EQ 'and (CAR (CDR (CDR (CDR (CDR (CDR V45)))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR (CDR V45)))))))
    (EQ 'then (CAR (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))
    (NULL (CDR (CDR (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))))
   (LET*
    ((V52 (CDR V45)) (V53 (CDR V52)) (V54 (CDR V53)) (V55 (CDR V54))
     (V56 (CAR V55)))
    (LIST 'LET (LIST (LIST (CAR V56) (LIST 'GENSYM "X")))
     (aum->lisp
      (CONS 'rename
       (CONS 'the (CONS 'variables (CONS 'in (CONS (CDR V56) (CDR V55))))))))))
  ((AND (CONSP V45) (EQ 'bind (CAR V45)) (CONSP (CDR V45))
    (CONSP (CDR (CDR V45))) (EQ 'to (CAR (CDR (CDR V45))))
    (CONSP (CDR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR (CDR V45)))))
    (EQ 'in (CAR (CDR (CDR (CDR (CDR V45))))))
    (CONSP (CDR (CDR (CDR (CDR (CDR V45))))))
    (NULL (CDR (CDR (CDR (CDR (CDR (CDR V45))))))))
   (LET* ((V57 (CDR V45)) (V58 (CDR V57)) (V59 (CDR V58)) (V60 (CAR V59)))
    (LET ((Vs (extract-vars V60)))
     (LET ((QuoteX (lisp-form Vs V60)))
      (LIST 'PROGV (LIST 'LIST (CAR V57)) (LIST 'LIST QuoteX)
       (aum->lisp (CAR (CDR (CDR V59)))))))))
  ((AND (CONSP V45) (CONSP (CDR V45)) (EQ 'is (CAR (CDR V45)))
    (CONSP (CDR (CDR V45))) (EQ 'identical (CAR (CDR (CDR V45))))
    (CONSP (CDR (CDR (CDR V45)))) (EQ 'to (CAR (CDR (CDR (CDR V45)))))
    (CONSP (CDR (CDR (CDR (CDR V45)))))
    (NULL (CDR (CDR (CDR (CDR (CDR V45)))))))
   (quote-equality-test (CAR (CDR (CDR (CDR (CDR V45))))) (CAR V45)))
  ((EQ 'fail! V45) NIL)
  ((AND (CONSP V45) (EQ 'the (CAR V45)) (CONSP (CDR V45))
    (EQ 'head (CAR (CDR V45))) (CONSP (CDR (CDR V45)))
    (EQ 'of (CAR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR V45))))
    (NULL (CDR (CDR (CDR (CDR V45))))))
   (CONS 'CAR (CDR (CDR (CDR V45)))))
  ((AND (CONSP V45) (EQ 'the (CAR V45)) (CONSP (CDR V45))
    (EQ 'tail (CAR (CDR V45))) (CONSP (CDR (CDR V45)))
    (EQ 'of (CAR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR V45))))
    (NULL (CDR (CDR (CDR (CDR V45))))))
   (CONS 'CDR (CDR (CDR (CDR V45)))))
  ((AND (CONSP V45) (EQ 'pop (CAR V45)) (CONSP (CDR V45))
    (EQ 'the (CAR (CDR V45))) (CONSP (CDR (CDR V45)))
    (EQ 'stack (CAR (CDR (CDR V45)))) (NULL (CDR (CDR (CDR V45)))))
   (LIST 'FUNCALL 'Continuation))
  ((AND (CONSP V45) (EQ 'call (CAR V45)) (CONSP (CDR V45))
    (EQ 'the (CAR (CDR V45))) (CONSP (CDR (CDR V45)))
    (EQ 'continuation (CAR (CDR (CDR V45)))) (CONSP (CDR (CDR (CDR V45))))
    (NULL (CDR (CDR (CDR (CDR V45))))))
   (LET* ((V61 (CDR V45)) (V62 (CDR V61)) (V63 (CDR V62)) (V64 (CAR V63)))
    (LIST 'PROG2 (LIST '+infs) (optimise-calls (body->lisp (extract-vars V64) V64)))))
  (T V45)))

(DEFUN quote-equality-test (V325 V326)
 (COND ((NULL V325) (LIST 'NULL V326))
  ((OR (NUMBERP V325) (CHARACTERP V325)) (LIST 'EQL V325 V326))
  ((OR (MEMBER V325 '(true false)) (wrapper (symbol? V325)))
   (LIST 'EQ (LIST 'QUOTE V325) V326))
  ((STRINGP V325) (LIST 'EQUAL V325 V326)) 
  (T (implementation_error 'quote-equality-test))))

(DEFUN +infs () (INCF *inferences*))

(DEFUN inferences (X) (DECLARE (IGNORE X)) *inferences*)

(SETQ *inferences* 0)

(DEFUN body->lisp (V7 V8)
 (COND ((NULL V8) (LIST 'FUNCALL 'Continuation))
  ((AND (CONSP V8) (CONSP (CAR V8)) (EQ '! (CAR (CAR V8)))
    (NULL (CDR (CAR V8))))
   (LIST 'OR (body->lisp V7 (CDR V8)) (LIST 'RETURN-FROM 'failure NIL)))
  ((AND (CONSP V8) (CONSP (CAR V8)))
   (LET
    ((Continuation
      (LIST 'FUNCTION (LIST 'LAMBDA NIL (body->lisp V7 (CDR V8))))))
    (LET ((Lisp (lisp-form V7 (CAR V8)))) (APPEND Lisp (LIST Continuation)))))
  (T (implementation_error 'body->lisp))))

(DEFMACRO prolog? (&REST Literals) 
  (LIST 'prolog-wrapper (build-prolog-call Literals)))

(DEFUN build-prolog-call (V25)
 (COND ((NULL V25) T)
  ((AND (CONSP V25) (CONSP (CAR V25)))
   (LET* ((V26 (CAR V25)))
    (CONS (m-prolog->s-prolog-predicate (CAR V26))
     (APPEND (CDR V26) (LIST (LIST 'freeze (build-prolog-call (CDR V25))))))))
  (T (implementation_error 'build-prolog-call))))

(DEFUN prolog-wrapper (V27)
 (IF (EQ V27 T) 'true (IF (NULL V27) 'false V27)))

(DEFUN answer (&REST X) (answer-help (BUTLAST X)))

(DEFUN answer-help (V28) (if (more? V28) NIL T))

(DEFUN more? (V29)
  (MAPCAR #'(LAMBDA (V) (output "~%~A = ~S~%" V (deref V))) V29)
  (if (THE SYMBOL (y-or-n? "~%More? ")) 'true 'false))

(DEFUN return (V36 V37) (DECLARE (IGNORE V37)) (deref V36))