/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.TransactionOptions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.InheritanceType;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ConnectionFactoryRegistry;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.jpa.JPAAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.store.DefaultCandidateExtent;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.appengine.BatchDeleteManager;
import org.datanucleus.store.appengine.BatchPutManager;
import org.datanucleus.store.appengine.DatastoreAdapter;
import org.datanucleus.store.appengine.DatastoreConnectionFactoryImpl;
import org.datanucleus.store.appengine.DatastoreFKListStore;
import org.datanucleus.store.appengine.DatastoreFKSetStore;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastorePluginRegistry;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.appengine.MetaDataValidator;
import org.datanucleus.store.appengine.StorageVersion;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.FKArrayStore;
import org.datanucleus.store.mapped.scostore.FKListStore;
import org.datanucleus.store.mapped.scostore.FKMapStore;
import org.datanucleus.store.mapped.scostore.FKSetStore;
import org.datanucleus.store.mapped.scostore.JoinArrayStore;
import org.datanucleus.store.mapped.scostore.JoinListStore;
import org.datanucleus.store.mapped.scostore.JoinMapStore;
import org.datanucleus.store.mapped.scostore.JoinSetStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreManager
extends MappedStoreManager {
    private final Set<String> validatedClasses = Collections.synchronizedSet(new HashSet());
    private static final String EXTENSION_PREFIX = "gae.";
    public static final String PARENT_PK = "gae.parent-pk";
    public static final String ENCODED_PK = "gae.encoded-pk";
    public static final String PK_NAME = "gae.pk-name";
    public static final String PK_ID = "gae.pk-id";
    public static final String UNINDEXED_PROPERTY = "gae.unindexed";
    public static final String EXCLUDE_QUERY_FROM_TXN = "gae.exclude-query-from-txn";
    private static final String READ_TIMEOUT_PROPERTY = "datanucleus.datastoreReadTimeout";
    static final String LEGACY_READ_TIMEOUT_PROPERTY = "datanucleus.query.timeout";
    private static final String WRITE_TIMEOUT_PROPERTY = "datanucleus.datastoreWriteTimeout";
    public static final String DATASTORE_READ_CONSISTENCY_PROPERTY = "datanucleus.appengine.datastoreReadConsistency";
    public static final String DATASTORE_ENABLE_XG_TXNS_PROPERTY = "datanucleus.appengine.datastoreEnableXGTransactions";
    public static final String JPA_QUERY_TIMEOUT_PROPERTY = "javax.persistence.query.timeout";
    public static final String JPA_QUERY_CHUNK_SIZE_PROPERTY = "javax.persistence.query.chunkSize";
    public static final String SLOW_BUT_MORE_ACCURATE_JPQL_DELETE_QUERY = "gae.slow-but-more-accurate-jpql-delete-query";
    public static final String GET_EXTENT_CAN_RETURN_SUBCLASSES_PROPERTY = "datanucleus.appengine.getExtentCanReturnSubclasses";
    private static final Map<InheritanceStrategy, String> INHERITANCE_STRATEGY_MAP = new ConcurrentHashMap<InheritanceStrategy, String>();
    private final BatchPutManager batchPutManager = new BatchPutManager();
    private final BatchDeleteManager batchDeleteManager = new BatchDeleteManager();
    private final StorageVersion storageVersion;
    private final DatastoreServiceConfig defaultDatastoreServiceConfigPrototypeForReads;
    private final DatastoreServiceConfig defaultDatastoreServiceConfigPrototypeForWrites;
    private final TransactionOptions defaultDatastoreTransactionOptionsPrototype;
    private static final String BAD_INHERITANCE_MESSAGE = "Found inheritance strategy '%s' on %s.  This strategy is not supported in this context.  Please see the documentation for information on using inheritance with %s: %s";
    private static final String JPA_INHERITANCE_DOCS_URL = "http://code.google.com/appengine/docs/java/datastore/usingjpa.html#Inheritance";
    private static final String JDO_INHERITANCE_DOCS_URL = "http://code.google.com/appengine/docs/java/datastore/dataclasses.html#Inheritance";

    public DatastoreManager(ClassLoaderResolver clr, OMFContext omfContext) throws NoSuchFieldException, IllegalAccessException {
        super("appengine", clr, DatastoreManager.addDefaultPropertyValues(omfContext));
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.google.appengine.api.datastore.DatastoreService", (String)"appengine-api.jar");
        this.defaultDatastoreServiceConfigPrototypeForReads = this.createDatastoreServiceConfigPrototypeForReads(omfContext.getPersistenceConfiguration());
        this.defaultDatastoreServiceConfigPrototypeForWrites = this.createDatastoreServiceConfigPrototypeForWrites(omfContext.getPersistenceConfiguration());
        this.defaultDatastoreTransactionOptionsPrototype = this.createDatastoreTransactionOptionsPrototype(omfContext.getPersistenceConfiguration());
        this.persistenceHandler = new DatastorePersistenceHandler((StoreManager)this);
        this.dba = new DatastoreAdapter();
        this.initialiseIdentifierFactory(omfContext);
        this.setCustomPluginManager();
        this.addTypeManagerMappings();
        PersistenceConfiguration persistenceConfig = omfContext.getPersistenceConfiguration();
        this.storageVersion = StorageVersion.fromConfig(persistenceConfig);
        this.initialiseAutoStart(clr);
        this.logConfiguration();
    }

    private DatastoreServiceConfig createDatastoreServiceConfigPrototypeForReads(PersistenceConfiguration persistenceConfig) {
        return this.createDatastoreServiceConfigPrototype(persistenceConfig, READ_TIMEOUT_PROPERTY, LEGACY_READ_TIMEOUT_PROPERTY);
    }

    private DatastoreServiceConfig createDatastoreServiceConfigPrototypeForWrites(PersistenceConfiguration persistenceConfig) {
        return this.createDatastoreServiceConfigPrototype(persistenceConfig, WRITE_TIMEOUT_PROPERTY);
    }

    private DatastoreServiceConfig createDatastoreServiceConfigPrototype(PersistenceConfiguration persistenceConfiguration, String ... timeoutProps) {
        DatastoreServiceConfig datastoreServiceConfig = DatastoreServiceConfig.Builder.withDefaults();
        for (String timeoutProp : timeoutProps) {
            int defaultDeadline = persistenceConfiguration.getIntProperty(timeoutProp);
            if (defaultDeadline <= 0) continue;
            datastoreServiceConfig.deadline((double)defaultDeadline / 1000.0);
        }
        String defaultReadConsistencyStr = persistenceConfiguration.getStringProperty(DATASTORE_READ_CONSISTENCY_PROPERTY);
        if (defaultReadConsistencyStr != null) {
            try {
                datastoreServiceConfig.readPolicy(new ReadPolicy(ReadPolicy.Consistency.valueOf((String)defaultReadConsistencyStr)));
            }
            catch (IllegalArgumentException iae) {
                throw new FatalNucleusUserException("Illegal value for datanucleus.appengine.datastoreReadConsistency.  Valid values are " + Arrays.toString(ReadPolicy.Consistency.values()));
            }
        }
        return datastoreServiceConfig;
    }

    private TransactionOptions createDatastoreTransactionOptionsPrototype(PersistenceConfiguration persistenceConfig) {
        return TransactionOptions.Builder.withXG((boolean)persistenceConfig.getBooleanProperty(DATASTORE_ENABLE_XG_TXNS_PROPERTY));
    }

    private void addTypeManagerMappings() throws NoSuchFieldException, IllegalAccessException {
        Field javaTypes = TypeManager.class.getDeclaredField("javaTypes");
        javaTypes.setAccessible(true);
        Map map = (Map)javaTypes.get(this.omfContext.getTypeManager());
        Object arrayListValue = map.get(ArrayList.class.getName());
        map.put("java.util.Arrays$ArrayList", arrayListValue);
    }

    private void setCustomPluginManager() throws NoSuchFieldException, IllegalAccessException {
        PluginManager pluginMgr = this.omfContext.getPluginManager();
        Field registryField = PluginManager.class.getDeclaredField("registry");
        registryField.setAccessible(true);
        registryField.set(pluginMgr, new DatastorePluginRegistry((PluginRegistry)registryField.get(pluginMgr)));
    }

    private static OMFContext addDefaultPropertyValues(OMFContext omfContext) {
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        conf.setProperty("datanucleus.attachSameDatastore", (Object)Boolean.TRUE.toString());
        if (conf.getProperty("datanucleus.appengine.autoCreateDatastoreTxns") == null) {
            conf.setProperty("datanucleus.appengine.autoCreateDatastoreTxns", (Object)Boolean.TRUE.toString());
        }
        conf.setProperty("datanucleus.datastoreTransactionFlushLimit", (Object)Integer.MAX_VALUE);
        conf.setProperty("datanucleus.query.cached", (Object)false);
        return omfContext;
    }

    public NucleusConnection getNucleusConnection(ObjectManager om) {
        ConnectionFactory cf = this.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory(this.txConnectionFactoryName);
        final boolean enlisted = om.getTransaction().isActive();
        final ManagedConnection mc = cf.getConnection((ObjectManager)(enlisted ? om : null), null);
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            public void run() {
                mc.unlock();
                if (!enlisted) {
                    // empty if block
                }
            }
        };
        return new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
    }

    public Date getDatastoreDate() {
        throw new UnsupportedOperationException();
    }

    public Extent getExtent(ObjectManager om, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, om.getClassLoaderResolver());
        this.validateMetaDataForClass(cmd, om.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        if (!this.getMetaDataManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty(GET_EXTENT_CAN_RETURN_SUBCLASSES_PROPERTY)) {
            subclasses = false;
        }
        return new DefaultCandidateExtent(om, c, subclasses, cmd);
    }

    protected void initialiseIdentifierFactory(OMFContext omfContext) {
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        String idFactoryName = conf.getStringProperty("datanucleus.identifierFactory");
        String idFactoryClassName = omfContext.getPluginManager().getAttributeValueForExtension("org.datanucleus.store_identifierfactory", "name", idFactoryName, "class-name");
        if (idFactoryClassName == null) {
            throw new FatalNucleusUserException(idFactoryName);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        this.addStringPropIfNotNull(conf, props, "datanucleus.mapping.Catalog", "DefaultCatalog");
        this.addStringPropIfNotNull(conf, props, "datanucleus.mapping.Schema", "DefaultSchema");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.case", "RequiredCase");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.wordSeparator", "WordSeparator");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.tablePrefix", "TablePrefix");
        this.addStringPropIfNotNull(conf, props, "datanucleus.identifier.tableSuffix", "TableSuffix");
        try {
            Class<?> cls = Class.forName(idFactoryClassName);
            Class[] argTypes = new Class[]{org.datanucleus.store.mapped.DatastoreAdapter.class, ClassLoaderResolver.class, Map.class};
            Object[] args = new Object[]{this.dba, omfContext.getClassLoaderResolver(null), props};
            this.identifierFactory = (IdentifierFactory)ClassUtils.newInstance(cls, (Class[])argTypes, (Object[])args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new FatalNucleusUserException(idFactoryName + ":" + idFactoryClassName, cnfe);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)e);
            throw new FatalNucleusUserException(idFactoryClassName, e);
        }
    }

    private void addStringPropIfNotNull(PersistenceConfiguration conf, Map<String, String> map, String propName, String mapKeyName) {
        String val = conf.getStringProperty(propName);
        if (val != null) {
            map.put(mapKeyName, val);
        }
    }

    public Collection<String> getSupportedOptions() {
        HashSet<String> opts = new HashSet<String>();
        opts.add("TransactionIsolationLevel.read-committed");
        opts.add("BackedSCO");
        opts.add("ApplicationIdentity");
        opts.add("OptimisticTransaction");
        return opts;
    }

    public FetchStatement getFetchStatement(DatastoreContainerObject table) {
        throw new UnsupportedOperationException();
    }

    public DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        return null;
    }

    protected StoreData newStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        MappedStoreData superData;
        AbstractClassMetaData[] managingCmds;
        InheritanceStrategy strat = cmd.getInheritanceMetaData().getStrategy();
        if (strat == InheritanceStrategy.SUBCLASS_TABLE) {
            return this.buildStoreDataWithNoTable(cmd);
        }
        if (strat == InheritanceStrategy.COMPLETE_TABLE) {
            if (cmd.isAbstractPersistenceCapable()) {
                return this.buildStoreDataWithNoTable(cmd);
            }
            return this.buildStoreData(cmd, clr);
        }
        if (strat == InheritanceStrategy.NEW_TABLE && (cmd.getSuperAbstractClassMetaData() == null || cmd.getSuperAbstractClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE)) {
            return this.buildStoreData(cmd, clr);
        }
        if (DatastoreManager.isNewOrSuperclassTableInheritanceStrategy((AbstractClassMetaData)cmd) && (managingCmds = this.getClassesManagingTableForClass((AbstractClassMetaData)cmd, clr)) != null && managingCmds.length == 1 && (superData = (MappedStoreData)this.storeDataMgr.get(managingCmds[0].getFullClassName())) != null) {
            DatastoreTable superTable = (DatastoreTable)superData.getDatastoreContainerObject();
            return this.buildStoreDataWithTable(cmd, superTable);
        }
        String unsupportedMsg = this.buildUnsupportedInheritanceStrategyMessage(cmd);
        throw new UnsupportedInheritanceStrategyException(unsupportedMsg);
    }

    private String buildUnsupportedInheritanceStrategyMessage(ClassMetaData cmd) {
        InheritanceStrategy strat = cmd.getInheritanceMetaData().getStrategy();
        if (this.isJPA()) {
            String jpaInheritanceType = this.getJPAInheritanceType(strat);
            return String.format(BAD_INHERITANCE_MESSAGE, jpaInheritanceType, cmd.getFullClassName(), "JPA", JPA_INHERITANCE_DOCS_URL);
        }
        return String.format(BAD_INHERITANCE_MESSAGE, strat, cmd.getFullClassName(), "JDO", JDO_INHERITANCE_DOCS_URL);
    }

    private String getJPAInheritanceType(InheritanceStrategy strat) {
        return INHERITANCE_STRATEGY_MAP.get(strat);
    }

    private StoreData buildStoreDataWithNoTable(ClassMetaData cmd) {
        MappedStoreData sdNew = new MappedStoreData(cmd, null, false);
        this.registerStoreData((StoreData)sdNew);
        return sdNew;
    }

    private StoreData buildStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        String tableName = cmd.getTable() != null ? cmd.getTable() : this.getIdentifierFactory().newDatastoreContainerIdentifier((AbstractClassMetaData)cmd).getIdentifierName();
        DatastoreTable table = new DatastoreTable(tableName, this, (AbstractClassMetaData)cmd, clr, this.dba);
        MappedStoreData sd = new MappedStoreData(cmd, (DatastoreContainerObject)table, true);
        this.registerStoreData((StoreData)sd);
        table.buildMapping();
        return sd;
    }

    private StoreData buildStoreDataWithTable(ClassMetaData cmd, DatastoreTable table) {
        MappedStoreData sd = new MappedStoreData(cmd, (DatastoreContainerObject)table, false);
        this.registerStoreData((StoreData)sd);
        sd.setDatastoreContainerObject((DatastoreClass)table);
        table.manageClass((AbstractClassMetaData)cmd);
        return sd;
    }

    public Object getResultValueAtPosition(Object key, JavaTypeMapping mapping, int position) {
        return key;
    }

    public boolean insertValuesOnInsert(DatastoreMapping datastoreMapping) {
        return true;
    }

    public boolean allowsBatching() {
        return false;
    }

    public FieldManager getFieldManagerForResultProcessing(StateManager sm, Object obj, StatementClassMapping resultMappings) {
        ObjectManager om = sm.getObjectManager();
        Class cls = om.getClassLoaderResolver().classForName(sm.getClassMetaData().getFullClassName());
        Object internalKey = EntityUtils.idToInternalKey(sm.getObjectManager(), cls, obj, true);
        return new KeyOnlyFieldManager(internalKey);
    }

    public FieldManager getFieldManagerForStatementGeneration(StateManager sm, Object stmt, StatementClassMapping stmtMappings, boolean checkNonNullable) {
        return null;
    }

    public ResultObjectFactory newResultObjectFactory(DatastoreClass table, AbstractClassMetaData acmd, StatementClassMapping mappingDefinition, boolean ignoreCache, boolean discriminator, FetchPlan fetchPlan, Class persistentClass) {
        return null;
    }

    protected FKArrayStore newFKArrayStore(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("FK Arrays not supported.");
    }

    protected FKListStore newFKListStore(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        return new DatastoreFKListStore(ammd, this, clr);
    }

    protected JoinArrayStore newJoinArrayStore(AbstractMemberMetaData amd, ClassLoaderResolver clr, DatastoreContainerObject arrayTable) {
        throw new UnsupportedOperationException("Join Arrays not supported.");
    }

    protected JoinMapStore newJoinMapStore(AbstractMemberMetaData amd, ClassLoaderResolver clr, DatastoreContainerObject mapTable) {
        throw new UnsupportedOperationException("Join Maps not supported.");
    }

    protected FKSetStore newFKSetStore(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        return new DatastoreFKSetStore(ammd, this, clr);
    }

    protected FKMapStore newFKMapStore(AbstractMemberMetaData clr, ClassLoaderResolver amd) {
        throw new UnsupportedOperationException("FK Maps not supported.");
    }

    protected JoinListStore newJoinListStore(AbstractMemberMetaData amd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        throw new UnsupportedOperationException("Join Lists not supported.");
    }

    protected JoinSetStore newJoinSetStore(AbstractMemberMetaData amd, ClassLoaderResolver clr, DatastoreContainerObject table) {
        throw new UnsupportedOperationException("Join Sets not supported.");
    }

    public BatchPutManager getBatchPutManager() {
        return this.batchPutManager;
    }

    public BatchDeleteManager getBatchDeleteManager() {
        return this.batchDeleteManager;
    }

    public boolean storageVersionAtLeast(StorageVersion storageVersion) {
        return this.getStorageVersion().ordinal() >= storageVersion.ordinal();
    }

    public TransactionOptions getDefaultDatastoreTransactionOptions() {
        return DatastoreManager.copyTransactionOptions(this.defaultDatastoreTransactionOptionsPrototype);
    }

    public DatastorePersistenceHandler getPersistenceHandler() {
        return (DatastorePersistenceHandler)super.getPersistenceHandler();
    }

    String getTxConnectionFactoryName() {
        return this.txConnectionFactoryName;
    }

    String getNonTxConnectionFactoryName() {
        return this.nontxConnectionFactoryName;
    }

    public boolean connectionFactoryIsTransactional() {
        ConnectionFactoryRegistry registry = this.getOMFContext().getConnectionFactoryRegistry();
        DatastoreConnectionFactoryImpl connFactory = (DatastoreConnectionFactoryImpl)registry.lookupConnectionFactory(this.txConnectionFactoryName);
        return connFactory.isTransactional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreTable getDatastoreClass(String className, ClassLoaderResolver clr) {
        try {
            DatastoreManager datastoreManager = this;
            synchronized (datastoreManager) {
                return (DatastoreTable)super.getDatastoreClass(className, clr);
            }
        }
        catch (NoTableManagedException e) {
            Class cls = clr.classForName(className);
            ApiAdapter api = this.getApiAdapter();
            if (cls != null && !cls.isInterface() && !api.isPersistable(cls)) {
                throw new NoTableManagedException("Class " + className + " does not seem to have been enhanced.  You may want to rerun " + "the enhancer and check for errors in the output.");
            }
            throw e;
        }
    }

    private static boolean memberHasExtension(AbstractClassMetaData acmd, int pos, String extensionName) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(pos);
        return ammd.hasExtension(extensionName);
    }

    static boolean hasEncodedPKField(AbstractClassMetaData acmd) {
        int pkPos = acmd.getPKMemberPositions()[0];
        return DatastoreManager.isEncodedPKField(acmd, pkPos);
    }

    static boolean isEncodedPKField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, ENCODED_PK);
    }

    static boolean isParentPKField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, PARENT_PK);
    }

    static boolean isPKNameField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, PK_NAME);
    }

    static boolean isPKIdField(AbstractClassMetaData acmd, int pos) {
        return DatastoreManager.memberHasExtension(acmd, pos, PK_ID);
    }

    public static boolean isNewOrSuperclassTableInheritanceStrategy(AbstractClassMetaData cmd) {
        while (cmd != null) {
            AbstractClassMetaData pcmd = cmd.getSuperAbstractClassMetaData();
            if (pcmd == null) {
                return cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE;
            }
            if (cmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) {
                return false;
            }
            cmd = pcmd;
        }
        return false;
    }

    public void validateMetaDataForClass(AbstractClassMetaData acmd, ClassLoaderResolver clr) {
        if (this.validatedClasses.add(acmd.getFullClassName())) {
            new MetaDataValidator(acmd, this.getMetaDataManager(), clr).validate();
        }
    }

    public void close() {
        this.validatedClasses.clear();
        super.close();
    }

    public boolean isJPA() {
        return JPAAdapter.class.isAssignableFrom(this.omfContext.getApiAdapter().getClass());
    }

    public StorageVersion getStorageVersion() {
        return this.storageVersion;
    }

    public DatastoreServiceConfig getDefaultDatastoreServiceConfigForReads() {
        return DatastoreManager.copyDatastoreServiceConfig(this.defaultDatastoreServiceConfigPrototypeForReads);
    }

    public DatastoreServiceConfig getDefaultDatastoreServiceConfigForWrites() {
        return DatastoreManager.copyDatastoreServiceConfig(this.defaultDatastoreServiceConfigPrototypeForWrites);
    }

    static DatastoreServiceConfig copyDatastoreServiceConfig(DatastoreServiceConfig config) {
        DatastoreServiceConfig newConfig = DatastoreServiceConfig.Builder.withImplicitTransactionManagementPolicy((ImplicitTransactionManagementPolicy)config.getImplicitTransactionManagementPolicy()).readPolicy(config.getReadPolicy());
        if (config.getDeadline() != null) {
            newConfig.deadline(config.getDeadline().doubleValue());
        }
        if (config.getMaxEntityGroupsPerRpc() != null) {
            config.maxEntityGroupsPerRpc(config.getMaxEntityGroupsPerRpc().intValue());
        }
        return newConfig;
    }

    static TransactionOptions copyTransactionOptions(TransactionOptions txnOpts) {
        TransactionOptions options = TransactionOptions.Builder.withDefaults();
        if (txnOpts.isXG()) {
            options.setXG(txnOpts.isXG());
        } else {
            options.clearXG();
        }
        return txnOpts;
    }

    static {
        INHERITANCE_STRATEGY_MAP.put(InheritanceStrategy.SUBCLASS_TABLE, "MappedSuperclass");
        INHERITANCE_STRATEGY_MAP.put(InheritanceStrategy.COMPLETE_TABLE, InheritanceType.TABLE_PER_CLASS.name());
        INHERITANCE_STRATEGY_MAP.put(InheritanceStrategy.NEW_TABLE, InheritanceType.JOINED.name());
        INHERITANCE_STRATEGY_MAP.put(InheritanceStrategy.SUPERCLASS_TABLE, InheritanceType.SINGLE_TABLE.name());
    }

    static final class UnsupportedInheritanceStrategyException
    extends FatalNucleusUserException {
        UnsupportedInheritanceStrategyException(String msg) {
            super(msg);
        }
    }

    private static final class KeyOnlyFieldManager
    implements FieldManager {
        private final Object key;

        private KeyOnlyFieldManager(Object key) {
            this.key = key;
        }

        public void storeBooleanField(int fieldNumber, boolean value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeByteField(int fieldNumber, byte value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeCharField(int fieldNumber, char value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeDoubleField(int fieldNumber, double value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeFloatField(int fieldNumber, float value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeIntField(int fieldNumber, int value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeLongField(int fieldNumber, long value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeShortField(int fieldNumber, short value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeStringField(int fieldNumber, String value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public void storeObjectField(int fieldNumber, Object value) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public boolean fetchBooleanField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public byte fetchByteField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public char fetchCharField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public double fetchDoubleField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public float fetchFloatField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public int fetchIntField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public long fetchLongField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public short fetchShortField(int fieldNumber) {
            throw new UnsupportedOperationException("Should only be using this for keys.");
        }

        public String fetchStringField(int fieldNumber) {
            return (String)this.key;
        }

        public Object fetchObjectField(int fieldNumber) {
            return this.key;
        }
    }
}

