/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import javax.jdo.PersistenceManager;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.ShortIdentity;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ASMUtils {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    public static final String ACN_boolean = Boolean.TYPE.getName();
    public static final String ACN_byte = Byte.TYPE.getName();
    public static final String ACN_char = Character.TYPE.getName();
    public static final String ACN_double = Double.TYPE.getName();
    public static final String ACN_float = Float.TYPE.getName();
    public static final String ACN_int = Integer.TYPE.getName();
    public static final String ACN_long = Long.TYPE.getName();
    public static final String ACN_short = Short.TYPE.getName();
    public static final String ACN_Boolean = Boolean.class.getName().replace('.', '/');
    public static final String ACN_Byte = Byte.class.getName().replace('.', '/');
    public static final String ACN_Character = Character.class.getName().replace('.', '/');
    public static final String ACN_Double = Double.class.getName().replace('.', '/');
    public static final String ACN_Float = Float.class.getName().replace('.', '/');
    public static final String ACN_Integer = Integer.class.getName().replace('.', '/');
    public static final String ACN_Long = Long.class.getName().replace('.', '/');
    public static final String ACN_Short = Short.class.getName().replace('.', '/');
    public static final String ACN_String = String.class.getName().replace('.', '/');
    public static final String ACN_Object = Object.class.getName().replace('.', '/');
    public static final String ACN_StateManager = StateManager.class.getName().replace('.', '/');
    public static final String ACN_PersistenceManager = PersistenceManager.class.getName().replace('.', '/');
    public static final String ACN_PersistenceCapable = PersistenceCapable.class.getName().replace('.', '/');
    public static final String ACN_Detachable = Detachable.class.getName().replace('.', '/');
    public static final String ACN_JDOPermission = JDOPermission.class.getName().replace('.', '/');
    public static final String ACN_SecurityManager = SecurityManager.class.getName().replace('.', '/');
    public static final String CD_String = Type.getDescriptor(String.class);
    public static final String CD_Object = Type.getDescriptor(Object.class);
    public static final String CD_ByteIdentity = Type.getDescriptor(ByteIdentity.class);
    public static final String CD_CharIdentity = Type.getDescriptor(CharIdentity.class);
    public static final String CD_IntIdentity = Type.getDescriptor(IntIdentity.class);
    public static final String CD_LongIdentity = Type.getDescriptor(LongIdentity.class);
    public static final String CD_ShortIdentity = Type.getDescriptor(ShortIdentity.class);
    public static final String CD_StringIdentity = Type.getDescriptor(StringIdentity.class);
    public static final String CD_ObjectIdentity = Type.getDescriptor(ObjectIdentity.class);
    public static final String CD_StateManager = Type.getDescriptor(StateManager.class);
    public static final String CD_PersistenceManager = Type.getDescriptor(PersistenceManager.class);
    public static final String CD_PersistenceCapable = Type.getDescriptor(PersistenceCapable.class);
    public static final String CD_Detachable = Type.getDescriptor(Detachable.class);
    public static final String CD_SecurityManager = Type.getDescriptor(SecurityManager.class);
    public static final String CD_ObjectIdFieldConsumer = Type.getDescriptor(PersistenceCapable.ObjectIdFieldConsumer.class);
    public static final String CD_ObjectIdFieldSupplier = Type.getDescriptor(PersistenceCapable.ObjectIdFieldSupplier.class);

    private ASMUtils() {
    }

    public static void addBIPUSHToMethod(MethodVisitor visitor, int i) {
        if (i < 6) {
            switch (i) {
                case 0: {
                    visitor.visitInsn(3);
                    break;
                }
                case 1: {
                    visitor.visitInsn(4);
                    break;
                }
                case 2: {
                    visitor.visitInsn(5);
                    break;
                }
                case 3: {
                    visitor.visitInsn(6);
                    break;
                }
                case 4: {
                    visitor.visitInsn(7);
                    break;
                }
                case 5: {
                    visitor.visitInsn(8);
                }
            }
        } else if (i < 127) {
            visitor.visitIntInsn(16, i);
        } else if (i < Short.MAX_VALUE) {
            visitor.visitIntInsn(17, i);
        }
    }

    public static void addReturnForType(MethodVisitor visitor, Class type) {
        if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            visitor.visitInsn(172);
        } else if (type == Double.TYPE) {
            visitor.visitInsn(175);
        } else if (type == Float.TYPE) {
            visitor.visitInsn(174);
        } else if (type == Long.TYPE) {
            visitor.visitInsn(173);
        } else {
            visitor.visitInsn(176);
        }
    }

    public static void addLoadForType(MethodVisitor visitor, Class type, int number) {
        if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            visitor.visitVarInsn(21, number);
        } else if (type == Double.TYPE) {
            visitor.visitVarInsn(24, number);
        } else if (type == Float.TYPE) {
            visitor.visitVarInsn(23, number);
        } else if (type == Long.TYPE) {
            visitor.visitVarInsn(22, number);
        } else {
            visitor.visitVarInsn(25, number);
        }
    }

    public static String getTypeNameForJDOMethod(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls == Boolean.TYPE) {
            return "Boolean";
        }
        if (cls == Byte.TYPE) {
            return "Byte";
        }
        if (cls == Character.TYPE) {
            return "Char";
        }
        if (cls == Double.TYPE) {
            return "Double";
        }
        if (cls == Float.TYPE) {
            return "Float";
        }
        if (cls == Integer.TYPE) {
            return "Int";
        }
        if (cls == Long.TYPE) {
            return "Long";
        }
        if (cls == Short.TYPE) {
            return "Short";
        }
        if (cls == String.class) {
            return "String";
        }
        return "Object";
    }

    public static String getTypeDescriptorForJDOMethod(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls == Boolean.TYPE) {
            return Type.BOOLEAN_TYPE.getDescriptor();
        }
        if (cls == Byte.TYPE) {
            return Type.BYTE_TYPE.getDescriptor();
        }
        if (cls == Character.TYPE) {
            return Type.CHAR_TYPE.getDescriptor();
        }
        if (cls == Double.TYPE) {
            return Type.DOUBLE_TYPE.getDescriptor();
        }
        if (cls == Float.TYPE) {
            return Type.FLOAT_TYPE.getDescriptor();
        }
        if (cls == Integer.TYPE) {
            return Type.INT_TYPE.getDescriptor();
        }
        if (cls == Long.TYPE) {
            return Type.LONG_TYPE.getDescriptor();
        }
        if (cls == Short.TYPE) {
            return Type.SHORT_TYPE.getDescriptor();
        }
        if (cls == String.class) {
            return CD_String;
        }
        return CD_Object;
    }

    public static String getTypeDescriptorForSingleFieldIdentityGetKey(String oidClassName) {
        if (oidClassName.equals(LongIdentity.class.getName())) {
            return Type.LONG_TYPE.getDescriptor();
        }
        if (oidClassName.equals(IntIdentity.class.getName())) {
            return Type.INT_TYPE.getDescriptor();
        }
        if (oidClassName.equals(ShortIdentity.class.getName())) {
            return Type.SHORT_TYPE.getDescriptor();
        }
        if (oidClassName.equals(CharIdentity.class.getName())) {
            return Type.CHAR_TYPE.getDescriptor();
        }
        if (oidClassName.equals(ByteIdentity.class.getName())) {
            return Type.BYTE_TYPE.getDescriptor();
        }
        if (oidClassName.equals(StringIdentity.class.getName())) {
            return CD_String;
        }
        if (oidClassName.equals(ObjectIdentity.class.getName())) {
            return CD_Object;
        }
        return null;
    }

    public static String getSingleFieldIdentityDescriptor(String oidClassName) {
        if (oidClassName.equals(LongIdentity.class.getName())) {
            return CD_LongIdentity;
        }
        if (oidClassName.equals(IntIdentity.class.getName())) {
            return CD_IntIdentity;
        }
        if (oidClassName.equals(StringIdentity.class.getName())) {
            return CD_StringIdentity;
        }
        if (oidClassName.equals(ShortIdentity.class.getName())) {
            return CD_ShortIdentity;
        }
        if (oidClassName.equals(CharIdentity.class.getName())) {
            return CD_CharIdentity;
        }
        if (oidClassName.equals(ByteIdentity.class.getName())) {
            return CD_ByteIdentity;
        }
        if (oidClassName.equals(ObjectIdentity.class.getName())) {
            return CD_ObjectIdentity;
        }
        return null;
    }

    public static String getTypeNameForUseWithSingleFieldIdentity(String oidClassName) {
        if (oidClassName == null) {
            return null;
        }
        if (oidClassName.equals(ByteIdentity.class.getName())) {
            return "Byte";
        }
        if (oidClassName.equals(CharIdentity.class.getName())) {
            return "Char";
        }
        if (oidClassName.equals(IntIdentity.class.getName())) {
            return "Int";
        }
        if (oidClassName.equals(LongIdentity.class.getName())) {
            return "Long";
        }
        if (oidClassName.equals(ShortIdentity.class.getName())) {
            return "Short";
        }
        if (oidClassName.equals(StringIdentity.class.getName())) {
            return "String";
        }
        return "Object";
    }

    public static String getASMClassNameForSingleFieldIdentityConstructor(Class fieldType) {
        if (fieldType == null) {
            return null;
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return ACN_Byte;
        }
        if (fieldType == Character.TYPE || fieldType == Character.class) {
            return ACN_Character;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return ACN_Integer;
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return ACN_Long;
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return ACN_Short;
        }
        if (fieldType == String.class) {
            return ACN_String;
        }
        return ACN_Object;
    }
}

