/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.devappserver2;

import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.client.HttpClient;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPost;
import com.google.appengine.repackaged.org.apache.http.entity.ByteArrayEntity;
import com.google.appengine.repackaged.org.apache.http.impl.client.HttpClientBuilder;
import com.google.appengine.tools.remoteapi.RemoteApiException;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteRpc {
    private static final Logger logger = Logger.getLogger(RemoteRpc.class.getName());
    private final RemoteApiOptions options;
    private final HttpClient httpClient;
    private int rpcCount = 0;

    RemoteRpc(RemoteApiOptions options) {
        this.options = options;
        this.httpClient = HttpClientBuilder.create().disableRedirectHandling().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] call(String serviceName, String methodName, String requestId, byte[] request) {
        logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: {0}.{1}", new Object[]{serviceName, methodName});
        long startTime = System.currentTimeMillis();
        try {
            RemoteApiPb.Request requestProto = RemoteRpc.makeRequest(serviceName, methodName, requestId, request);
            RemoteApiPb.Response responseProto = this.callImpl(requestProto);
            if (responseProto.hasJavaException()) {
                logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: failed due to a server-side Java exception");
                Throwable exception = RemoteRpc.parseJavaException(responseProto, requestProto.getServiceName(), requestProto.getMethod());
                throw new RemoteApiException("response was an exception", requestProto.getServiceName(), requestProto.getMethod(), exception);
            }
            if (responseProto.hasException()) {
                String pickle = responseProto.getException();
                logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: failed due to a server-side Python exception:\n{0}", pickle);
                String string = String.valueOf(pickle);
                throw new RemoteApiException(string.length() != 0 ? "response was a python exception:\n".concat(string) : new String("response was a python exception:\n"), requestProto.getServiceName(), requestProto.getMethod(), null);
            }
            byte[] byArray = responseProto.getResponseAsBytes();
            return byArray;
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: took {0} ms", elapsedTime);
        }
    }

    RemoteApiPb.Response callImpl(RemoteApiPb.Request requestProto) {
        ++this.rpcCount;
        byte[] requestBytes = requestProto.toByteArray();
        String string = this.options.getHostname();
        int n = this.options.getPort();
        String string2 = this.options.getRemoteApiPath();
        String url = new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string2).length()).append("http://").append(string).append(":").append(n).append(string2).toString();
        HttpPost post = new HttpPost(url);
        post.addHeader("Host", this.options.getHostname());
        post.addHeader("X-appcfg-api-version", "1");
        post.addHeader("Content-Type", "application/octet-stream");
        post.setEntity(new ByteArrayEntity(requestBytes));
        try {
            byte[] body;
            HttpResponse response = this.httpClient.execute(post);
            if (response.getStatusLine().getStatusCode() != 200) {
                string2 = String.valueOf(response.getStatusLine());
                throw RemoteRpc.makeException(new StringBuilder(26 + String.valueOf(string2).length()).append("unexpected HTTP response: ").append(string2).toString(), null, requestProto);
            }
            RemoteApiPb.Response parsedResponse = new RemoteApiPb.Response();
            int max = this.options.getMaxHttpResponseSize();
            byte[] buf = new byte[65536];
            try (InputStream in = response.getEntity().getContent();
                 ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                int n2;
                while (bout.size() < max && (n2 = in.read(buf, 0, Math.min(buf.length, max - bout.size()))) > 0) {
                    bout.write(buf, 0, n2);
                }
                body = bout.toByteArray();
            }
            boolean parsed = parsedResponse.parseFrom(body);
            if (!parsed || !parsedResponse.isInitialized()) {
                throw RemoteRpc.makeException("Could not parse Remote API response", null, requestProto);
            }
            return parsedResponse;
        }
        catch (IOException e) {
            throw RemoteRpc.makeException("I/O error", e, requestProto);
        }
    }

    void resetRpcCount() {
        this.rpcCount = 0;
    }

    int getRpcCount() {
        return this.rpcCount;
    }

    private static RemoteApiPb.Request makeRequest(String packageName, String methodName, String requestId, byte[] payload) {
        RemoteApiPb.Request result = new RemoteApiPb.Request();
        result.setServiceName(packageName);
        result.setMethod(methodName);
        result.setRequestAsBytes(payload);
        result.setRequestId(requestId);
        return result;
    }

    private static Throwable parseJavaException(RemoteApiPb.Response parsedResponse, String packageName, String methodName) {
        try {
            ByteArrayInputStream ins = new ByteArrayInputStream(parsedResponse.getJavaExceptionAsBytes());
            ObjectInputStream in = new ObjectInputStream(ins);
            return (Throwable)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RemoteApiException("remote API call: can't deserialize server-side exception", packageName, methodName, (Throwable)e);
        }
    }

    private static RemoteApiException makeException(String message, Throwable cause, RemoteApiPb.Request request) {
        logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "makeException", "remote API call: {0}", message);
        String string = String.valueOf(message);
        return new RemoteApiException(string.length() != 0 ? "remote API call: ".concat(string) : new String("remote API call: "), request.getServiceName(), request.getMethod(), cause);
    }
}

