/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.compound;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.compound.CompoundWordTokenFilterBase;
import com.google.appengine.repackaged.org.apache.lucene.analysis.compound.hyphenation.Hyphenation;
import com.google.appengine.repackaged.org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import java.io.File;
import java.io.Reader;
import java.util.Set;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilter
extends CompoundWordTokenFilterBase {
    private HyphenationTree hyphenator;

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(input, hyphenator, HyphenationCompoundWordTokenFilter.makeDictionary(dictionary), minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, String[] dictionary) {
        this(input, hyphenator, HyphenationCompoundWordTokenFilter.makeDictionary(dictionary), 5, 2, 15, false);
    }

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, Set dictionary) {
        this(input, hyphenator, dictionary, 5, 2, 15, false);
    }

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, Set dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
        this.hyphenator = hyphenator;
    }

    public static HyphenationTree getHyphenationTree(String hyphenationFilename) throws Exception {
        return HyphenationCompoundWordTokenFilter.getHyphenationTree(new InputSource(hyphenationFilename));
    }

    public static HyphenationTree getHyphenationTree(File hyphenationFile) throws Exception {
        return HyphenationCompoundWordTokenFilter.getHyphenationTree(new InputSource(hyphenationFile.toURL().toExternalForm()));
    }

    public static HyphenationTree getHyphenationTree(Reader hyphenationReader) throws Exception {
        InputSource is = new InputSource(hyphenationReader);
        is.setSystemId("urn:java:" + HyphenationTree.class.getName());
        return HyphenationCompoundWordTokenFilter.getHyphenationTree(is);
    }

    public static HyphenationTree getHyphenationTree(InputSource hyphenationSource) throws Exception {
        HyphenationTree tree = new HyphenationTree();
        tree.loadPatterns(hyphenationSource);
        return tree;
    }

    protected void decomposeInternal(Token token) {
        Hyphenation hyphens = this.hyphenator.hyphenate(token.termBuffer(), 0, token.termLength(), 1, 1);
        if (hyphens == null) {
            return;
        }
        int[] hyp = hyphens.getHyphenationPoints();
        char[] lowerCaseTermBuffer = HyphenationCompoundWordTokenFilter.makeLowerCaseCopy(token.termBuffer());
        for (int i = 0; i < hyp.length; ++i) {
            int partLength;
            int remaining = hyp.length - i;
            int start = hyp[i];
            Token longestMatchToken = null;
            for (int j = 1; j < remaining && (partLength = hyp[i + j] - start) <= this.maxSubwordSize; ++j) {
                if (partLength < this.minSubwordSize) continue;
                if (this.dictionary.contains(lowerCaseTermBuffer, start, partLength)) {
                    if (this.onlyLongestMatch) {
                        if (longestMatchToken != null) {
                            if (longestMatchToken.termLength() >= partLength) continue;
                            longestMatchToken = this.createToken(start, partLength, token);
                            continue;
                        }
                        longestMatchToken = this.createToken(start, partLength, token);
                        continue;
                    }
                    this.tokens.add(this.createToken(start, partLength, token));
                    continue;
                }
                if (!this.dictionary.contains(lowerCaseTermBuffer, start, partLength - 1)) continue;
                if (this.onlyLongestMatch) {
                    if (longestMatchToken != null) {
                        if (longestMatchToken.termLength() >= partLength - 1) continue;
                        longestMatchToken = this.createToken(start, partLength - 1, token);
                        continue;
                    }
                    longestMatchToken = this.createToken(start, partLength - 1, token);
                    continue;
                }
                this.tokens.add(this.createToken(start, partLength - 1, token));
            }
            if (!this.onlyLongestMatch || longestMatchToken == null) continue;
            this.tokens.add(longestMatchToken);
        }
    }
}

