/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.ngram;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;

public class EdgeNGramTokenFilter
extends TokenFilter {
    public static final Side DEFAULT_SIDE = Side.FRONT;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private int minGram;
    private int maxGram;
    private Side side;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curGramSize;
    private int tokStart;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;

    protected EdgeNGramTokenFilter(TokenStream input) {
        super(input);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public EdgeNGramTokenFilter(TokenStream input, Side side, int minGram, int maxGram) {
        super(input);
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public EdgeNGramTokenFilter(TokenStream input, String sideLabel, int minGram, int maxGram) {
        this(input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.curTermBuffer = (char[])this.termAtt.termBuffer().clone();
                this.curTermLength = this.termAtt.termLength();
                this.curGramSize = this.minGram;
                this.tokStart = this.offsetAtt.startOffset();
            }
            if (this.curGramSize <= this.maxGram && this.curGramSize <= this.curTermLength && this.curGramSize <= this.maxGram) {
                int start = this.side == Side.FRONT ? 0 : this.curTermLength - this.curGramSize;
                int end = start + this.curGramSize;
                this.clearAttributes();
                this.offsetAtt.setOffset(this.tokStart + start, this.tokStart + end);
                this.termAtt.setTermBuffer(this.curTermBuffer, start, this.curGramSize);
                ++this.curGramSize;
                return true;
            }
            this.curTermBuffer = null;
        }
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
    }

    public static class Side {
        private String label;
        public static Side FRONT = new Side("front");
        public static Side BACK = new Side("back");

        private Side(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

