/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.th;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopAnalyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Tokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.th.ThaiWordFilter;
import com.google.appengine.repackaged.org.apache.lucene.util.Version;
import java.io.IOException;
import java.io.Reader;

public class ThaiAnalyzer
extends Analyzer {
    private final Version matchVersion;

    public ThaiAnalyzer() {
        this(Version.LUCENE_23);
    }

    public ThaiAnalyzer(Version matchVersion) {
        this.setOverridesTokenStreamMethod(ThaiAnalyzer.class);
        this.matchVersion = matchVersion;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream ts = new StandardTokenizer(this.matchVersion, reader);
        ts = new StandardFilter(ts);
        ts = new ThaiWordFilter(ts);
        ts = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), ts, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        return ts;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter(streams.source);
            streams.result = new ThaiWordFilter(streams.result);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.result, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
            streams.result.reset();
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

