/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.document.FieldSelector;
import com.google.appengine.repackaged.org.apache.lucene.index.CorruptIndexException;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.Collector;
import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSet;
import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSetIterator;
import com.google.appengine.repackaged.org.apache.lucene.search.Explanation;
import com.google.appengine.repackaged.org.apache.lucene.search.Filter;
import com.google.appengine.repackaged.org.apache.lucene.search.HitCollectorWrapper;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.Scorer;
import com.google.appengine.repackaged.org.apache.lucene.search.Searcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.SortField;
import com.google.appengine.repackaged.org.apache.lucene.search.TopDocCollector;
import com.google.appengine.repackaged.org.apache.lucene.search.TopDocs;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldCollector;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocCollector;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import com.google.appengine.repackaged.org.apache.lucene.search.TopScoreDocCollector;
import com.google.appengine.repackaged.org.apache.lucene.search.Weight;
import com.google.appengine.repackaged.org.apache.lucene.store.Directory;
import com.google.appengine.repackaged.org.apache.lucene.util.ReaderUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;
    private IndexReader[] subReaders;
    private int[] docStarts;
    private boolean fieldSortDoTrackScores;
    private boolean fieldSortDoMaxScore;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndexSearcher(String path) throws CorruptIndexException, IOException {
        this(IndexReader.open(path), true);
    }

    public IndexSearcher(String path, boolean readOnly) throws CorruptIndexException, IOException {
        this(IndexReader.open(path, readOnly), true);
    }

    public IndexSearcher(Directory directory) throws CorruptIndexException, IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(Directory path, boolean readOnly) throws CorruptIndexException, IOException {
        this(IndexReader.open(path, readOnly), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
        ArrayList subReadersList = new ArrayList();
        this.gatherSubReaders(subReadersList, this.reader);
        this.subReaders = subReadersList.toArray(new IndexReader[subReadersList.size()]);
        this.docStarts = new int[this.subReaders.length];
        int maxDoc = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.docStarts[i] = maxDoc;
            maxDoc += this.subReaders[i].maxDoc();
        }
    }

    protected void gatherSubReaders(List allSubReaders, IndexReader r) {
        ReaderUtil.gatherSubReaders(allSubReaders, r);
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public Document doc(int i) throws CorruptIndexException, IOException {
        return this.reader.document(i);
    }

    public Document doc(int i, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.reader.document(i, fieldSelector);
    }

    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        if (nDocs <= 0) {
            throw new IllegalArgumentException("nDocs must be > 0");
        }
        nDocs = Math.min(nDocs, this.reader.maxDoc());
        TopScoreDocCollector collector = TopScoreDocCollector.create(nDocs, !weight.scoresDocsOutOfOrder());
        this.search(weight, filter, (Collector)collector);
        return collector.topDocs();
    }

    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        return this.search(weight, filter, nDocs, sort, true);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort, boolean fillFields) throws IOException {
        nDocs = Math.min(nDocs, this.reader.maxDoc());
        SortField[] fields = sort.fields;
        boolean legacy = false;
        for (int i = 0; i < fields.length; ++i) {
            SortField field = fields[i];
            String fieldname = field.getField();
            int type = field.getType();
            if (type == 2) {
                int autotype = SortField.detectFieldType(this.reader, fieldname);
                fields[i] = autotype == 3 ? new SortField(fieldname, field.getLocale(), field.getReverse()) : new SortField(fieldname, autotype, field.getReverse());
            }
            if (!field.getUseLegacySearch()) continue;
            legacy = true;
        }
        if (legacy) {
            TopFieldDocCollector collector = new TopFieldDocCollector(this.reader, sort, nDocs);
            HitCollectorWrapper hcw = new HitCollectorWrapper(collector);
            hcw.setNextReader(this.reader, 0);
            if (filter == null) {
                Scorer scorer = weight.scorer(this.reader, true, true);
                if (scorer != null) {
                    scorer.score(hcw);
                }
            } else {
                this.searchWithFilter(this.reader, weight, filter, hcw);
            }
            return (TopFieldDocs)((TopDocCollector)collector).topDocs();
        }
        TopFieldCollector collector = TopFieldCollector.create(sort, nDocs, fillFields, this.fieldSortDoTrackScores, this.fieldSortDoMaxScore, !weight.scoresDocsOutOfOrder());
        this.search(weight, filter, (Collector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    public void search(Weight weight, Filter filter, Collector collector) throws IOException {
        if (filter == null) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                collector.setNextReader(this.subReaders[i], this.docStarts[i]);
                Scorer scorer = weight.scorer(this.subReaders[i], !collector.acceptsDocsOutOfOrder(), true);
                if (scorer == null) continue;
                scorer.score(collector);
            }
        } else {
            for (int i = 0; i < this.subReaders.length; ++i) {
                collector.setNextReader(this.subReaders[i], this.docStarts[i]);
                this.searchWithFilter(this.subReaders[i], weight, filter, collector);
            }
        }
    }

    private void searchWithFilter(IndexReader reader, Weight weight, Filter filter, Collector collector) throws IOException {
        if (!$assertionsDisabled && filter == null) {
            throw new AssertionError();
        }
        Scorer scorer = weight.scorer(reader, true, false);
        if (scorer == null) {
            return;
        }
        int docID = scorer.docID();
        if (!$assertionsDisabled && docID != -1 && docID != Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        DocIdSet filterDocIdSet = filter.getDocIdSet(reader);
        if (filterDocIdSet == null) {
            return;
        }
        DocIdSetIterator filterIter = filterDocIdSet.iterator();
        if (filterIter == null) {
            return;
        }
        int filterDoc = filterIter.nextDoc();
        int scorerDoc = scorer.advance(filterDoc);
        collector.setScorer(scorer);
        while (true) {
            if (scorerDoc == filterDoc) {
                if (scorerDoc == Integer.MAX_VALUE) break;
                collector.collect(scorerDoc);
                filterDoc = filterIter.nextDoc();
                scorerDoc = scorer.advance(filterDoc);
                continue;
            }
            if (scorerDoc > filterDoc) {
                filterDoc = filterIter.advance(scorerDoc);
                continue;
            }
            scorerDoc = scorer.advance(filterDoc);
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        int n = ReaderUtil.subIndex(doc, this.docStarts);
        int deBasedDoc = doc - this.docStarts[n];
        return weight.explain(this.subReaders[n], deBasedDoc);
    }

    public void setDefaultFieldSortScoring(boolean doTrackScores, boolean doMaxScore) {
        this.fieldSortDoTrackScores = doTrackScores;
        this.fieldSortDoMaxScore = doMaxScore;
    }

    static {
        $assertionsDisabled = !IndexSearcher.class.desiredAssertionStatus();
    }
}

