/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.names;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;

public class Names {
    public static final String URI_MEANING_ZLIB = "ZLIB";
    public static final String RESERVED_DELIMITER = "__";
    private static final ByteString RESERVED_DELIMITER_BYTES = ByteString.copyFromUtf8((String)"__");
    private static final byte[] RESERVED_DELIMITER_BYTE_ARRAY = RESERVED_DELIMITER_BYTES.toByteArray();

    private Names() {
    }

    public static boolean isNameReserved(String name) {
        return name.length() > 2 * RESERVED_DELIMITER.length() && name.startsWith(RESERVED_DELIMITER) && name.endsWith(RESERVED_DELIMITER);
    }

    public static boolean isNameReserved(ByteString name) {
        return name.size() > 2 * RESERVED_DELIMITER_BYTES.size() && name.startsWith(RESERVED_DELIMITER_BYTES) && name.endsWith(RESERVED_DELIMITER_BYTES);
    }

    public static boolean isNameReserved(byte[] name) {
        if (name.length <= 2 * RESERVED_DELIMITER_BYTE_ARRAY.length) {
            return false;
        }
        int endBase = name.length - RESERVED_DELIMITER_BYTE_ARRAY.length;
        for (int i = 0; i < RESERVED_DELIMITER_BYTE_ARRAY.length; ++i) {
            if (name[i] != RESERVED_DELIMITER_BYTE_ARRAY[i]) {
                return false;
            }
            if (name[endBase + i] == RESERVED_DELIMITER_BYTE_ARRAY[i]) continue;
            return false;
        }
        return true;
    }
}

