/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.LogicalCondition;
import javax.annotation.Nullable;

public abstract class ConditionVisitor {
    protected abstract boolean visit(Condition var1);

    public boolean visitAllConditions(@Nullable Condition condition) {
        if (condition == null) {
            return false;
        }
        return this.visitConditions(true, condition);
    }

    public boolean visitLeafConditions(@Nullable Condition condition) {
        if (condition == null) {
            return false;
        }
        return this.visitConditions(false, condition);
    }

    private boolean visitConditions(boolean includeLogicalConditions, Condition condition) {
        boolean isLogical = condition instanceof LogicalCondition;
        if ((includeLogicalConditions || !isLogical) && this.visit(condition)) {
            return true;
        }
        if (isLogical) {
            LogicalCondition logicalCondition = (LogicalCondition)condition;
            for (Condition subCondition : logicalCondition.subConditions()) {
                if (!this.visitConditions(includeLogicalConditions, subCondition)) continue;
                return true;
            }
        }
        return false;
    }
}

