/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityDiff;
import com.google.cloud.datastore.core.rep.SpecialPropertyDescriptor;
import com.google.cloud.datastore.core.rep.Value;
import java.util.Set;
import javax.annotation.Nullable;

public final class EntityDiffer {
    private EntityDiffer() {
    }

    @Nullable
    public static EntityDiff diff(@Nullable Entity before, @Nullable Entity after) {
        EntityDiffer.validateDiff(before, after);
        return EntityDiffer.uncheckedDiff(before, after);
    }

    @Nullable
    private static EntityDiff uncheckedDiff(@Nullable Entity before, @Nullable Entity after) {
        if (before == null || after == null) {
            return null;
        }
        return EntityDiffer.nestedDiff(before.propertyMap(), after.propertyMap());
    }

    @Nullable
    public static EntityDiff nestedDiff(ImmutableMap<String, Value> as, ImmutableMap<String, Value> bs) {
        ImmutableMap.Builder propertyDiffs = ImmutableMap.builder();
        for (String key : Sets.union((Set)as.keySet(), (Set)bs.keySet())) {
            EntityDiff.PropertyDiff propertyDiff = EntityDiffer.valueDiff((Value)as.get((Object)key), (Value)bs.get((Object)key));
            if (propertyDiff == null) continue;
            propertyDiffs.put((Object)key, (Object)propertyDiff);
        }
        return EntityDiff.create((ImmutableMap<String, EntityDiff.PropertyDiff>)propertyDiffs.build());
    }

    @Nullable
    private static EntityDiff.PropertyDiff valueDiff(@Nullable Value a, @Nullable Value b) {
        if (a == null) {
            return EntityDiff.PropertyDiff.create(b);
        }
        if (b == null) {
            return EntityDiff.PropertyDiff.delete(a);
        }
        ImmutableMap<String, Value> aNestedMap = EntityDiffer.toNestedMap(a);
        ImmutableMap<String, Value> bNestedMap = EntityDiffer.toNestedMap(b);
        if (aNestedMap != null && bNestedMap != null) {
            EntityDiff child = EntityDiffer.nestedDiff(aNestedMap, bNestedMap);
            if (child != null) {
                return EntityDiff.PropertyDiff.ofNested(child);
            }
            if (a.isDatastoreIndexed() != b.isDatastoreIndexed()) {
                return EntityDiff.PropertyDiff.ofNested(EntityDiff.empty());
            }
        } else if (!a.equals(b)) {
            return EntityDiff.PropertyDiff.update(a, b);
        }
        return null;
    }

    @Nullable
    private static ImmutableMap<String, Value> toNestedMap(Value a) {
        if (a.type() == Value.Type.MAP) {
            return a.asMap();
        }
        if (a.type() == Value.Type.ENTITY) {
            return ImmutableMap.builder().putAll(a.asEntity().propertyMap()).put((Object)SpecialPropertyDescriptor.KEY.asString(), (Object)Value.createEntityRef(a.asEntity().ref())).build();
        }
        return null;
    }

    private static void validateDiff(@Nullable Entity before, @Nullable Entity after) {
        Preconditions.checkArgument((before != null || after != null ? 1 : 0) != 0, (Object)"change(null, null) is meaningless");
        Preconditions.checkArgument((before == null || after == null || before.ref().equals(after.ref()) ? 1 : 0) != 0, (Object)"change(a, b) called on different entities");
    }
}

