/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.AutoValue_MutationResult;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.Value;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class MutationResult {
    public abstract OnestoreEntity.Reference key();

    @Nullable
    public abstract Entity entity();

    @Nullable
    public abstract ImmutableList<Value> transformedValues();

    public abstract boolean isDelete();

    public abstract boolean keyWasAllocated();

    public abstract boolean conflictDetected();

    public abstract long createVersion();

    public abstract long updateVersion();

    @Nullable
    public abstract DatastoreException exception();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_MutationResult.Builder().conflictDetected(false).isDelete(false).keyWasAllocated(false).conflictDetected(false).createVersion(-1L).updateVersion(-1L);
    }

    public MutationResult withUpdateVersion(long updateVersion) {
        long createVersion = this.createVersion();
        if (createVersion == -1L) {
            createVersion = updateVersion;
        }
        return this.toBuilder().updateVersion(updateVersion).createVersion(createVersion).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder key(OnestoreEntity.Reference var1);

        public abstract Builder entity(@Nullable Entity var1);

        public abstract Builder transformedValues(@Nullable List<Value> var1);

        public abstract Builder isDelete(boolean var1);

        public abstract Builder keyWasAllocated(boolean var1);

        public abstract Builder conflictDetected(boolean var1);

        public abstract Builder createVersion(long var1);

        public abstract Builder updateVersion(long var1);

        public abstract Builder exception(DatastoreException var1);

        public abstract MutationResult build();
    }
}

