/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;

public class RepHelper {
    public static final int NANOSECONDS_PER_SECOND = 1000000000;
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final long TIMESTAMP_MIN_SECONDS = -62135596800L;
    public static final long TIMESTAMP_MAX_SECONDS = 253402300799L;
    public static final long TIMESTAMP_MIN_MICROSECONDS = -62135596800000000L;
    public static final long TIMESTAMP_MAX_MICROSECONDS = 253402300799999999L;

    protected RepHelper() {
    }

    public static boolean isMicrosecondsInTimestampBounds(long microseconds) {
        return microseconds >= -62135596800000000L && microseconds <= 253402300799999999L;
    }

    public static boolean isSecondsInTimestampBounds(long seconds) {
        return seconds >= -62135596800L && seconds <= 253402300799L;
    }

    public static boolean isTrivialPropertyPath(PropertyPath path) {
        while (path != null) {
            if (!(path.segment() instanceof PropertyPathSegment.Member)) {
                return false;
            }
            path = path.next();
        }
        return true;
    }
}

