/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.MutationHelper;
import com.google.cloud.datastore.core.rep.OriginalMutationInfo;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Write;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;

public final class WriteHelper {
    private WriteHelper() {
    }

    public static Write.Builder toWriteWithCollapsing(ImmutableList<Mutation> originalMutationsList) throws InvalidConversionException {
        ImmutableList.Builder originalMutationInfoBuilder = ImmutableList.builder();
        ImmutableList<Mutation> collapsedMutations = WriteHelper.collapseMutations(originalMutationsList, arg_0 -> ((ImmutableList.Builder)originalMutationInfoBuilder).add(arg_0));
        ImmutableList originalMutationInfos = originalMutationInfoBuilder.build();
        Preconditions.checkState((originalMutationsList.size() == originalMutationInfos.size() ? 1 : 0) != 0);
        return Write.builder().mutations((Iterable<Mutation>)collapsedMutations).originalMutationInfos((ImmutableList<OriginalMutationInfo>)originalMutationInfos);
    }

    private static ImmutableList<Mutation> collapseMutations(ImmutableList<Mutation> originalMutations, Consumer<OriginalMutationInfo> originalMutationInfoConsumer) throws InvalidConversionException {
        ArrayList collapsedMutations = Lists.newArrayListWithCapacity((int)originalMutations.size());
        HashMap collapsedMutationMapping = Maps.newHashMapWithExpectedSize((int)originalMutations.size());
        for (int i = 0; i < originalMutations.size(); ++i) {
            Mutation mutation = (Mutation)originalMutations.get(i);
            OnestoreEntity.Reference key = mutation.key();
            if (V3Paths.hasIncompleteLastElement(key)) {
                collapsedMutations.add(mutation);
                originalMutationInfoConsumer.accept(OriginalMutationInfo.builder().collapsedMutationIndex(collapsedMutations.size() - 1).build());
                continue;
            }
            Integer collapsedMutationsIndex = (Integer)collapsedMutationMapping.get(key);
            if (collapsedMutationsIndex == null) {
                collapsedMutationsIndex = collapsedMutations.size();
                collapsedMutations.add(mutation);
                collapsedMutationMapping.put(key, collapsedMutationsIndex);
            } else {
                Mutation previousMutation = (Mutation)collapsedMutations.get(collapsedMutationsIndex);
                Mutation collapsedMutation = MutationHelper.collapse(previousMutation, mutation);
                collapsedMutations.set(collapsedMutationsIndex, collapsedMutation);
            }
            originalMutationInfoConsumer.accept(OriginalMutationInfo.builder().collapsedMutationIndex(collapsedMutationsIndex).transformationSize(mutation.transformation() == null ? 0 : mutation.transformation().propertyTransformations().size()).build());
        }
        return ImmutableList.copyOf((Collection)collapsedMutations);
    }
}

