/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import java.nio.charset.StandardCharsets;

public final class GoogleSqlUnescaper {
    private GoogleSqlUnescaper() {
    }

    public static String unescapeIdentifier(String escaped) {
        try {
            return GoogleSqlUnescaper.unescapeOrThrow(escaped);
        }
        catch (InvalidConversionException e) {
            return null;
        }
    }

    private static String unescapeOrThrow(String str) throws InvalidConversionException {
        boolean isQuoted;
        boolean bl = isQuoted = !str.isEmpty() && str.charAt(0) == '`';
        if (!isQuoted) {
            if (!GoogleSqlUnescaper.isValidUnquotedIdentifier(str)) {
                throw new InvalidConversionException("illegal unquoted identifier");
            }
            return str;
        }
        if (str.length() < 2 || str.charAt(str.length() - 1) != '`') {
            throw new InvalidConversionException("illegal identifier");
        }
        String quoted = str.substring(1, str.length() - 1);
        return GoogleSqlUnescaper.unescapeCInternal(quoted);
    }

    private static boolean isValidUnquotedIdentifier(String identifier) {
        if (identifier.isEmpty()) {
            return false;
        }
        byte[] bytes = identifier.getBytes(StandardCharsets.UTF_8);
        byte first = bytes[0];
        if (!GoogleSqlUnescaper.isAlpha(first) && first != 95) {
            return false;
        }
        for (int i = 1; i < bytes.length; ++i) {
            byte c = bytes[i];
            if (GoogleSqlUnescaper.isAlnum(c) || c == 95) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlpha(byte c) {
        return 65 <= c && c <= 90 || 97 <= c && c <= 122;
    }

    private static boolean isDigit(byte c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isAlnum(byte c) {
        return GoogleSqlUnescaper.isAlpha(c) || GoogleSqlUnescaper.isDigit(c);
    }

    private static String unescapeCInternal(String quoted) throws InvalidConversionException {
        if (quoted.isEmpty()) {
            throw new InvalidConversionException("quoted identifier cannot be empty");
        }
        StringBuilder buf = new StringBuilder();
        block18: for (int i = 0; i < quoted.length(); ++i) {
            char c = quoted.charAt(i);
            if (c == '`') {
                throw new InvalidConversionException("quoted identifier cannot contain unescaped quote");
            }
            if (c == '\r') {
                buf.append('\n');
                if (i + 1 >= quoted.length() || quoted.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            if (i + 1 >= quoted.length()) {
                throw new InvalidConversionException("illegal trailing backslash");
            }
            switch (quoted.charAt(++i)) {
                case 'a': {
                    buf.appendCodePoint(7);
                    continue block18;
                }
                case 'b': {
                    buf.append('\b');
                    continue block18;
                }
                case 'f': {
                    buf.append('\f');
                    continue block18;
                }
                case 'n': {
                    buf.append('\n');
                    continue block18;
                }
                case 'r': {
                    buf.append('\r');
                    continue block18;
                }
                case 't': {
                    buf.append('\t');
                    continue block18;
                }
                case 'v': {
                    buf.appendCodePoint(11);
                    continue block18;
                }
                case '?': {
                    buf.append('?');
                    continue block18;
                }
                case '\\': {
                    buf.append('\\');
                    continue block18;
                }
                case '\'': {
                    buf.append('\'');
                    continue block18;
                }
                case '\"': {
                    buf.append('\"');
                    continue block18;
                }
                case '`': {
                    buf.append('`');
                    continue block18;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    if (i + 3 > quoted.length()) {
                        throw new InvalidConversionException("illegal octal escape sequence");
                    }
                    buf.appendCodePoint(GoogleSqlUnescaper.unescapeOctal(quoted.substring(i, i + 3)));
                    i += 3;
                    continue block18;
                }
                case 'X': 
                case 'x': {
                    if (++i + 2 > quoted.length()) {
                        throw new InvalidConversionException("illegal hex escape sequence");
                    }
                    buf.appendCodePoint(GoogleSqlUnescaper.unescapeHex(quoted.substring(i, i + 2)));
                    i += 2;
                    continue block18;
                }
                case 'u': {
                    if (++i + 4 > quoted.length()) {
                        throw new InvalidConversionException("illegal unicode escape sequence");
                    }
                    buf.appendCodePoint(GoogleSqlUnescaper.unescapeHex(quoted.substring(i, i + 4)));
                    i += 4;
                    continue block18;
                }
                case 'U': {
                    if (++i + 8 > quoted.length()) {
                        throw new InvalidConversionException("illegal unicode escape sequence");
                    }
                    buf.appendCodePoint(GoogleSqlUnescaper.unescapeHex(quoted.substring(i, i + 8)));
                    i += 8;
                    continue block18;
                }
                default: {
                    throw new InvalidConversionException("illegal escape");
                }
            }
        }
        return buf.toString();
    }

    private static int unescapeOctal(String str) throws InvalidConversionException {
        int ch = 0;
        for (int i = 0; i < str.length(); ++i) {
            ch = 8 * ch + GoogleSqlUnescaper.octalValue(str.charAt(i));
        }
        if (!Character.isValidCodePoint(ch)) {
            throw new InvalidConversionException("illegal codepoint");
        }
        return ch;
    }

    private static int unescapeHex(String str) throws InvalidConversionException {
        int ch = 0;
        for (int i = 0; i < str.length(); ++i) {
            ch = 16 * ch + GoogleSqlUnescaper.hexValue(str.charAt(i));
        }
        if (!Character.isValidCodePoint(ch)) {
            throw new InvalidConversionException("illegal codepoint");
        }
        return ch;
    }

    private static int octalValue(char d) throws InvalidConversionException {
        if (d >= '0' && d <= '7') {
            return d - 48;
        }
        throw new InvalidConversionException("illegal octal digit");
    }

    private static int hexValue(char d) throws InvalidConversionException {
        if (d >= '0' && d <= '9') {
            return d - 48;
        }
        if (d >= 'a' && d <= 'f') {
            return 10 + d - 97;
        }
        if (d >= 'A' && d <= 'F') {
            return 10 + d - 65;
        }
        throw new InvalidConversionException("illegal hex digit");
    }
}

