/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.capabilities;

import com.google.appengine.api.capabilities.CapabilitiesService;
import com.google.appengine.api.capabilities.Capability;
import com.google.appengine.api.capabilities.CapabilityServicePb;
import com.google.appengine.api.capabilities.CapabilityState;
import com.google.appengine.api.capabilities.CapabilityStatus;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;

class CapabilitiesServiceImpl
implements CapabilitiesService {
    static final String PACKAGE_NAME = "capability_service";
    static final String METHOD_NAME = "IsEnabled";

    CapabilitiesServiceImpl() {
    }

    @Override
    public CapabilityState getStatus(Capability capability) {
        if (capability.equals(Capability.DATASTORE_WRITE)) {
            return CapabilitiesServiceImpl.queryCapabilityService(capability);
        }
        return new CapabilityState(capability, CapabilityStatus.ENABLED);
    }

    private static CapabilityState queryCapabilityService(Capability capability) {
        CapabilityStatus statusValue;
        CapabilityServicePb.IsEnabledResponse response;
        CapabilityServicePb.IsEnabledRequest.Builder builder = CapabilityServicePb.IsEnabledRequest.newBuilder();
        builder.setPackage(capability.getPackageName());
        builder.addCapability(capability.getName());
        CapabilityServicePb.IsEnabledRequest request = builder.build();
        byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE_NAME, METHOD_NAME, request.toByteArray());
        try {
            response = CapabilityServicePb.IsEnabledResponse.parseFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ApiProxy.ArgumentException(PACKAGE_NAME, METHOD_NAME);
        }
        switch (response.getSummaryStatus()) {
            case ENABLED: {
                statusValue = CapabilityStatus.ENABLED;
                break;
            }
            case DISABLED: {
                statusValue = CapabilityStatus.DISABLED;
                break;
            }
            default: {
                statusValue = CapabilityStatus.UNKNOWN;
            }
        }
        return new CapabilityState(capability, statusValue);
    }
}

