/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.xmpp.InboundMessageParser;
import com.google.appengine.api.xmpp.InboundPresenceParser;
import com.google.appengine.api.xmpp.InboundSubscriptionParser;
import com.google.appengine.api.xmpp.JID;
import com.google.appengine.api.xmpp.Message;
import com.google.appengine.api.xmpp.Presence;
import com.google.appengine.api.xmpp.PresenceBuilder;
import com.google.appengine.api.xmpp.PresenceShow;
import com.google.appengine.api.xmpp.PresenceType;
import com.google.appengine.api.xmpp.SendResponse;
import com.google.appengine.api.xmpp.Subscription;
import com.google.appengine.api.xmpp.XMPPFailureException;
import com.google.appengine.api.xmpp.XMPPService;
import com.google.appengine.api.xmpp.XMPPServicePb;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

class XMPPServiceImpl
implements XMPPService {
    static final String PACKAGE = "xmpp";
    static final int MAX_STATUS_MESSAGE_SIZE = 1024;

    XMPPServiceImpl() {
    }

    @Override
    public Presence getPresence(JID jabberId) {
        return this.getPresence(jabberId, null);
    }

    @Override
    public Presence getPresence(JID jabberId, JID fromJid) {
        byte[] responseBytes;
        this.checkArgument(jabberId != null, "Jabber ID cannot be null");
        XMPPServicePb.PresenceRequest request = new XMPPServicePb.PresenceRequest();
        request.setJid(jabberId.getId());
        if (fromJid != null) {
            request.setFromJid(fromJid.getId());
        }
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "GetPresence", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (XMPPServicePb.XmppServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INVALID_JID: {
                    String string = String.valueOf(jabberId);
                    throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Invalid jabber ID: ").append(string).toString());
                }
                case NONDEFAULT_MODULE: {
                    throw new UnsupportedOperationException("XMPP API does not support modules");
                }
            }
            String string = String.valueOf(jabberId);
            throw new XMPPFailureException(new StringBuilder(49 + String.valueOf(string).length()).append("Unknown error retrieving presence for jabber ID: ").append(string).toString());
        }
        XMPPServicePb.PresenceResponse response = new XMPPServicePb.PresenceResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new XMPPFailureException("Could not parse PresenceResponse");
        }
        return this.presenceFromPresenceResponse(jabberId, fromJid, response, true);
    }

    @Override
    public List<Presence> getPresence(Iterable<JID> jabberIds) {
        return this.getPresence(jabberIds, null);
    }

    @Override
    public List<Presence> getPresence(Iterable<JID> jabberIds, JID fromJid) {
        byte[] responseBytes;
        this.checkArgument(jabberIds != null, "Jabber ID list cannot be null");
        XMPPServicePb.BulkPresenceRequest request = new XMPPServicePb.BulkPresenceRequest();
        for (JID jabberId : jabberIds) {
            request.addJid(jabberId.getId());
        }
        this.checkArgument(!request.jids().isEmpty(), "Jabber ID list cannot be empty");
        if (fromJid != null) {
            request.setFromJid(fromJid.getId());
        }
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "BulkGetPresence", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (XMPPServicePb.XmppServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INVALID_JID: {
                    String string = String.valueOf(jabberIds);
                    throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length()).append("One or more jabber ID is invalid: ").append(string).toString());
                }
                case NONDEFAULT_MODULE: {
                    throw new UnsupportedOperationException("XMPP API does not support modules");
                }
            }
            throw new XMPPFailureException(String.format("Unknown error [code %d] retrieving presence for jabber IDs: %s", ex.getApplicationError(), jabberIds));
        }
        XMPPServicePb.BulkPresenceResponse response = new XMPPServicePb.BulkPresenceResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new XMPPFailureException("Could not parse BulkPresenceResponse");
        }
        ImmutableList.Builder retVal = new ImmutableList.Builder();
        for (int i = 0; i < response.presenceResponseSize(); ++i) {
            XMPPServicePb.PresenceResponse presenceResponse = response.getPresenceResponse(i);
            retVal.add(this.presenceFromPresenceResponse(new JID(request.getJid(i)), fromJid, presenceResponse, presenceResponse.isValid()));
        }
        return retVal.build();
    }

    @Override
    public void sendPresence(JID jabberId, PresenceType type, PresenceShow show, String status) {
        this.sendPresence(jabberId, type, show, status, null);
    }

    @Override
    public void sendPresence(JID jabberId, PresenceType type, PresenceShow show, String status, JID fromJid) {
        byte[] responseBytes;
        this.checkArgument(jabberId != null, "Jabber ID cannot be null");
        this.checkArgument(status == null || status.length() <= 1024, "Status message is too long");
        XMPPServicePb.XmppSendPresenceRequest request = new XMPPServicePb.XmppSendPresenceRequest();
        request.setJid(jabberId.getId());
        if (type != null) {
            switch (type) {
                case AVAILABLE: {
                    break;
                }
                default: {
                    request.setType(type.toString().toLowerCase());
                }
            }
        }
        if (show != null) {
            switch (show) {
                case NONE: {
                    break;
                }
                default: {
                    request.setShow(show.toString().toLowerCase());
                }
            }
        }
        if (status != null) {
            request.setStatus(status);
        }
        if (fromJid != null) {
            request.setFromJid(fromJid.getId());
        }
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "SendPresence", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (XMPPServicePb.XmppServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INVALID_JID: {
                    String string = String.valueOf(jabberId);
                    throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Invalid jabber ID: ").append(string).toString());
                }
                case INVALID_SHOW: {
                    String string = String.valueOf((Object)show);
                    throw new IllegalArgumentException(new StringBuilder(14 + String.valueOf(string).length()).append("Invalid show: ").append(string).toString());
                }
                case INVALID_TYPE: {
                    String string = String.valueOf((Object)type);
                    throw new IllegalArgumentException(new StringBuilder(14 + String.valueOf(string).length()).append("Invalid type: ").append(string).toString());
                }
                case NONDEFAULT_MODULE: {
                    throw new UnsupportedOperationException("XMPP API does not support modules");
                }
            }
            String string = String.valueOf(jabberId);
            throw new XMPPFailureException(new StringBuilder(45 + String.valueOf(string).length()).append("Unknown error sending presence to jabber ID: ").append(string).toString());
        }
        XMPPServicePb.XmppSendPresenceResponse response = new XMPPServicePb.XmppSendPresenceResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new XMPPFailureException("Could not parse XmppSendPresenceResponse");
        }
    }

    @Override
    public void sendInvitation(JID jabberId) {
        this.sendInvitation(jabberId, null);
    }

    @Override
    public void sendInvitation(JID jabberId, JID fromJid) {
        byte[] responseBytes;
        this.checkArgument(jabberId != null, "Jabber ID cannot be null");
        XMPPServicePb.XmppInviteRequest request = new XMPPServicePb.XmppInviteRequest();
        request.setJid(jabberId.getId());
        if (fromJid != null) {
            request.setFromJid(fromJid.getId());
        }
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "SendInvite", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (XMPPServicePb.XmppServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INVALID_JID: {
                    String string = String.valueOf(jabberId);
                    throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Invalid jabber ID: ").append(string).toString());
                }
                case NONDEFAULT_MODULE: {
                    throw new UnsupportedOperationException("XMPP API does not support modules");
                }
            }
            String string = String.valueOf(jabberId);
            throw new XMPPFailureException(new StringBuilder(47 + String.valueOf(string).length()).append("Unknown error sending invitation to jabber ID: ").append(string).toString());
        }
        XMPPServicePb.XmppInviteResponse response = new XMPPServicePb.XmppInviteResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new XMPPFailureException("Could not parse XmppInviteResponse");
        }
    }

    @Override
    public SendResponse sendMessage(Message message) {
        this.checkArgument(message != null, "Message cannot be null");
        this.checkArgument(message.getBody() != null && !message.getBody().isEmpty(), "Body cannot be null or empty");
        this.checkArgument(message.getRecipientJids() != null && message.getRecipientJids().length > 0, "Must provide at least one recipient");
        XMPPServicePb.XmppMessageRequest request = this.createMessageRequest(message);
        XMPPServicePb.XmppMessageResponse response = this.doMessageRpc(request);
        return this.translateMessageResponse(response, message.getRecipientJids());
    }

    @Override
    public Message parseMessage(HttpServletRequest request) throws IOException {
        return InboundMessageParser.parseMessage(request);
    }

    @Override
    public Presence parsePresence(HttpServletRequest request) throws IOException {
        return InboundPresenceParser.parsePresence(request);
    }

    @Override
    public Subscription parseSubscription(HttpServletRequest request) throws IOException {
        return InboundSubscriptionParser.parseSubscription(request);
    }

    private Presence presenceFromPresenceResponse(JID jabberId, JID fromJid, XMPPServicePb.PresenceResponse response, boolean valid) {
        PresenceBuilder builder = new PresenceBuilder().withToJid(jabberId).withFromJid(fromJid).withValid(valid).withPresenceType(response.isIsAvailable() ? PresenceType.AVAILABLE : PresenceType.UNAVAILABLE);
        if (response.hasPresence()) {
            XMPPServicePb.PresenceResponse.SHOW responseShow = XMPPServicePb.PresenceResponse.SHOW.valueOf(response.getPresence());
            builder.withPresenceShow(PresenceShow.fromPresenceResponseEnum(responseShow));
        }
        return builder.build();
    }

    private XMPPServicePb.XmppMessageRequest createMessageRequest(Message message) {
        XMPPServicePb.XmppMessageRequest request = new XMPPServicePb.XmppMessageRequest();
        for (JID jabberId : message.getRecipientJids()) {
            request.addJid(jabberId.getId());
        }
        request.setBody(message.getBody());
        request.setRawXml(message.isXml());
        request.setType(message.getMessageType().getInternalName());
        if (message.getFromJid() != null) {
            request.setFromJid(message.getFromJid().getId());
        }
        return request;
    }

    private SendResponse translateMessageResponse(XMPPServicePb.XmppMessageResponse response, JID ... jabberIds) {
        SendResponse retVal = new SendResponse();
        block5: for (int i = 0; i < jabberIds.length; ++i) {
            switch (XMPPServicePb.XmppMessageResponse.XmppMessageStatus.valueOf(response.getStatus(i))) {
                case INVALID_JID: {
                    retVal.addStatus(jabberIds[i], SendResponse.Status.INVALID_ID);
                    continue block5;
                }
                case NO_ERROR: {
                    retVal.addStatus(jabberIds[i], SendResponse.Status.SUCCESS);
                    continue block5;
                }
                case OTHER_ERROR: {
                    retVal.addStatus(jabberIds[i], SendResponse.Status.OTHER_ERROR);
                    continue block5;
                }
            }
        }
        return retVal;
    }

    private XMPPServicePb.XmppMessageResponse doMessageRpc(XMPPServicePb.XmppMessageRequest request) {
        byte[] responseBytes;
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "SendMessage", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (XMPPServicePb.XmppServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INVALID_JID: {
                    throw new IllegalArgumentException("Invalid jabber ID");
                }
                case NO_BODY: {
                    throw new IllegalArgumentException("Missing message body");
                }
                case INVALID_XML: {
                    throw new IllegalArgumentException("XML was invalid");
                }
                case INVALID_TYPE: {
                    throw new IllegalArgumentException("Type attribute is invalid");
                }
                case NONDEFAULT_MODULE: {
                    throw new UnsupportedOperationException("XMPP API does not support modules");
                }
            }
            throw new XMPPFailureException("Unknown error sending message");
        }
        XMPPServicePb.XmppMessageResponse response = new XMPPServicePb.XmppMessageResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new XMPPFailureException("Could not parse XmppMessageResponse");
        }
        return response;
    }

    private void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

