/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.time;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.time.SystemTimeSource;
import com.google.appengine.repackaged.com.google.common.time.TimeSourceBasedClock;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;

@FunctionalInterface
@GwtIncompatible
public interface TimeSource {
    public static TimeSource system() {
        return SystemTimeSource.INSTANCE;
    }

    public Instant now();

    default public LocalDateTime now(ZoneId zoneId) {
        return this.now().atZone(zoneId).toLocalDateTime();
    }

    default public LocalDate today(ZoneId zoneId) {
        return this.now().atZone(zoneId).toLocalDate();
    }

    default public Clock asClock(ZoneId zoneId) {
        return new TimeSourceBasedClock(this, zoneId);
    }
}

