/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.datanucleus.MetaDataUtils;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public class QueryEntityPKFetchFieldManager
extends AbstractFieldManager {
    AbstractClassMetaData cmd;
    Entity datastoreEntity;

    public QueryEntityPKFetchFieldManager(AbstractClassMetaData cmd, Entity entity) {
        this.cmd = cmd;
        this.datastoreEntity = entity;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.fetchObjectField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.fetchObjectField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.fetchObjectField(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.fetchObjectField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.fetchObjectField(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.fetchObjectField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.fetchObjectField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.fetchObjectField(fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        if (this.isPK(fieldNumber)) {
            return this.fetchStringPKField(fieldNumber);
        }
        return null;
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (this.isPK(fieldNumber)) {
            if (ammd.getType().equals(Key.class)) {
                return this.datastoreEntity.getKey();
            }
            if (ammd.getType().equals(Long.class)) {
                return this.datastoreEntity.getKey().getId();
            }
        }
        return null;
    }

    private String fetchStringPKField(int fieldNumber) {
        if (MetaDataUtils.isEncodedPKField(this.cmd, fieldNumber)) {
            return KeyFactory.keyToString((Key)this.datastoreEntity.getKey());
        }
        if (this.datastoreEntity.getKey().isComplete() && this.datastoreEntity.getKey().getName() == null) {
            throw new NucleusFatalUserException("The primary key for " + this.cmd.getFullClassName() + " is an unencoded " + "string but the key of the corresponding entity in the datastore does not have a " + "name.  You may want to either change the primary key to be an encoded string " + "(add the \"" + "gae.encoded-pk" + "\" extension), change the " + "primary key to be of type " + Key.class.getName() + ", or, if you're certain that " + "this class will never have a parent, change the primary key to be of type Long.");
        }
        return this.datastoreEntity.getKey().getName();
    }

    protected boolean isPK(int fieldNumber) {
        int[] pkPositions = this.cmd.getPKMemberPositions();
        return pkPositions != null && pkPositions[0] == fieldNumber;
    }
}

