/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.SearchBaseException;
import com.google.appengine.api.search.SearchServiceException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class FutureHelper {
    FutureHelper() {
    }

    static <T> T quietGet(Future<T> future) throws SearchBaseException {
        try {
            return FutureHelper.getInternal(future);
        }
        catch (ExecutionException e) {
            return FutureHelper.processExecutionException(e);
        }
    }

    static <T, E extends Exception> T quietGet(Future<T> future, Class<E> exceptionClass) throws E, SearchBaseException {
        try {
            return FutureHelper.getInternal(future);
        }
        catch (ExecutionException e) {
            if (e.getCause().getClass().equals(exceptionClass)) {
                Exception exception = (Exception)e.getCause();
                throw exception;
            }
            return FutureHelper.processExecutionException(e);
        }
    }

    private static <T> T getInternal(Future<T> future) throws ExecutionException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new SearchServiceException("Unexpected failure", e);
        }
    }

    private static <T> T processExecutionException(ExecutionException e) {
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        throw new UndeclaredThrowableException(e.getCause());
    }

    static class FakeFuture<T>
    implements Future<T> {
        private final T result;

        FakeFuture(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            return this.result;
        }
    }
}

