/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.MatchScorer;
import com.google.appengine.api.search.RescoringMatchScorer;
import com.google.appengine.api.search.SortExpression;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.SortOptionsChecker;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SortOptions {
    private final List<SortExpression> sortExpressions;
    private final MatchScorer matchScorer;
    private final int limit;

    private SortOptions(Builder builder) {
        this.matchScorer = builder.matchScorer;
        this.limit = Util.defaultIfNull(builder.limit, 1000);
        this.sortExpressions = new ArrayList<SortExpression>(builder.sortExpressions);
    }

    public List<SortExpression> getSortExpressions() {
        return Collections.unmodifiableList(this.sortExpressions);
    }

    public MatchScorer getMatchScorer() {
        return this.matchScorer;
    }

    public int getLimit() {
        return this.limit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    SearchServicePb.SearchParams.Builder copyToProtocolBuffer(SearchServicePb.SearchParams.Builder builder) {
        SearchServicePb.ScorerSpec.Builder scorerSpecBuilder = null;
        scorerSpecBuilder = this.matchScorer != null ? this.matchScorer.copyToScorerSpecProtocolBuffer() : SearchServicePb.ScorerSpec.newBuilder();
        scorerSpecBuilder.setLimit(this.limit);
        builder.setScorerSpec(scorerSpecBuilder);
        for (SortExpression expression : this.sortExpressions) {
            builder.addSortSpec(expression.copyToProtocolBuffer());
        }
        return builder;
    }

    public String toString() {
        return String.format("SortOptions(limit=%d, matchScorer=%s, sortExpressions=%s)", this.limit, this.matchScorer, this.sortExpressions);
    }

    public static final class Builder {
        private MatchScorer matchScorer;
        private Integer limit;
        private final List<SortExpression> sortExpressions = new ArrayList<SortExpression>();

        private Builder() {
        }

        public Builder setLimit(int limit) {
            this.limit = SortOptionsChecker.checkLimit(limit);
            return this;
        }

        public Builder setMatchScorer(MatchScorer matchScorer) {
            this.matchScorer = matchScorer;
            return this;
        }

        public Builder setMatchScorer(MatchScorer.Builder builder) {
            this.matchScorer = builder.build();
            return this;
        }

        public Builder setMatchScorer(RescoringMatchScorer.Builder builder) {
            this.matchScorer = builder.build();
            return this;
        }

        public Builder addSortExpression(SortExpression sortExpression) {
            this.sortExpressions.add(Preconditions.checkNotNull(sortExpression, "sort expression cannot be null"));
            return this;
        }

        public Builder addSortExpression(SortExpression.Builder builder) {
            Preconditions.checkNotNull(builder, "sort expression builder cannot be null");
            this.sortExpressions.add(builder.build());
            return this;
        }

        public SortOptions build() {
            return new SortOptions(this);
        }
    }
}

