/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import java.util.Random;

public class CloudTraceContext {
    private static final long INVALID_SPAN_ID = 0L;
    private static final long MASK_TRACE_ENABLED = 1L;
    private static final Random random = new Random();
    private final byte[] traceId;
    private final long parentSpanId;
    private final long spanId;
    private final long traceMask;

    public CloudTraceContext(byte[] traceId, long spanId, long traceMask) {
        this(traceId, 0L, spanId, traceMask);
    }

    public CloudTraceContext(byte[] traceId, long parentSpanId, long spanId, long traceMask) {
        this.traceId = traceId;
        this.parentSpanId = parentSpanId;
        this.spanId = spanId;
        this.traceMask = traceMask;
    }

    public CloudTraceContext createChildContext() {
        return new CloudTraceContext(this.traceId, this.spanId, random.nextLong(), this.getTraceMask());
    }

    public byte[] getTraceId() {
        return this.traceId;
    }

    public long getParentSpanId() {
        return this.parentSpanId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getTraceMask() {
        return this.traceMask;
    }

    public boolean isTraceEnabled() {
        return (this.traceMask & 1L) != 0L;
    }
}

