/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.ResultSet;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class SimpleListResultSet
extends ResultSet {
    private SimpleListResultSet(List<List<?>> data, List<Client.ColumnProto> columns) {
        super(null, SimpleListResultSet.createData(data), columns, null, "", SqlRpcOptions.defaultOptions().setResultSetType(1004));
    }

    private static List<Client.ColumnProto> createColumns(Iterable<String> columnNames) {
        ArrayList<Client.ColumnProto> results = Util.newArrayList();
        for (String columnName : columnNames) {
            results.add(Client.ColumnProto.newBuilder().setName(columnName).setLabel(columnName).build());
        }
        return results;
    }

    private static List<Client.TupleProto> createData(List<List<?>> data) {
        ArrayList<Client.TupleProto> results = Util.newArrayList();
        for (List<?> currentRow : data) {
            Client.TupleProto.Builder builder = Client.TupleProto.newBuilder();
            int currentColumn = 0;
            for (Object columnValue : currentRow) {
                if (columnValue == null) {
                    builder.addNulls(currentColumn);
                } else {
                    builder.addValues(ByteString.copyFromUtf8(String.valueOf(columnValue)));
                }
                ++currentColumn;
            }
            results.add(builder.build());
        }
        return results;
    }

    public static SimpleListResultSet emptyResultSet() {
        List<List<?>> rows = Collections.emptyList();
        return new SimpleListResultSet(rows, SimpleListResultSet.createColumns(Collections.emptyList()));
    }

    public static SimpleListResultSet emptyResultSet(Enum<?> ... columnNames) {
        List<List<?>> rows = Collections.emptyList();
        return SimpleListResultSet.newEnumResultSet(rows, columnNames);
    }

    public static SimpleListResultSet oneColumnResultSet(List<?> data, String columnName) {
        Util.checkNotNull(columnName, "columnName may not be null");
        ArrayList<List<?>> rows = Util.newArrayList();
        for (Object type : data) {
            rows.add(Collections.singletonList(type));
        }
        return new SimpleListResultSet(rows, SimpleListResultSet.createColumns(Collections.singletonList(columnName)));
    }

    public static SimpleListResultSet newEnumResultSet(List<List<?>> data, Enum<?> ... columnNames) {
        Util.checkNotNull(columnNames, "columnName may not be null");
        ArrayList<String> columnNamesString = Util.newArrayList();
        for (Enum<?> columnName : columnNames) {
            columnNamesString.add(columnName.name());
        }
        return new SimpleListResultSet(data, SimpleListResultSet.createColumns(columnNamesString));
    }

    public static SimpleListResultSet newOneColumnEnumResultSet(List<?> data, Enum<?> columnName) {
        ArrayList<List<?>> rows = Util.newArrayList();
        for (Object row : data) {
            rows.add(Collections.singletonList(row));
        }
        return SimpleListResultSet.newEnumResultSet(rows, columnName);
    }

    public static SimpleListResultSet newResultSet(List<List<?>> rows, List<String> columnNames) {
        return new SimpleListResultSet(rows, SimpleListResultSet.createColumns(columnNames));
    }

    public static SimpleListResultSet newResultSet(List<List<?>> rows, List<String> columnsNames, List<JdbcType> columnTypes) throws SQLException {
        ArrayList<Client.ColumnProto> columns = Util.newArrayList();
        Util.checkParameter(columnsNames.size() == columnTypes.size(), "columnNames length should match columnTypes. {0} != {1}", columnsNames.size(), columnTypes.size());
        Iterator<JdbcType> jdbcTypeIter = columnTypes.iterator();
        for (String name : columnsNames) {
            int type = jdbcTypeIter.next().getCode();
            columns.add(Client.ColumnProto.newBuilder().setName(name).setLabel(name).setType(type).build());
        }
        return new SimpleListResultSet(rows, columns);
    }
}

