/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.tools.remoteapi.RemoteApiClient;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.util.ArrayList;
import java.util.List;

abstract class BaseRemoteApiClient
implements RemoteApiClient {
    private final String hostname;
    private final int port;
    private final String remoteApiPath;
    private final String appId;

    BaseRemoteApiClient(RemoteApiOptions options, String appId) {
        this.hostname = options.getHostname();
        this.port = options.getPort();
        this.remoteApiPath = options.getRemoteApiPath();
        this.appId = appId;
    }

    @Override
    public String getRemoteApiPath() {
        return this.remoteApiPath;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    String getHostname() {
        return this.hostname;
    }

    int getPort() {
        return this.port;
    }

    String makeUrl(String path) {
        if (!path.startsWith("/")) {
            String string = String.valueOf(path);
            throw new IllegalArgumentException(string.length() != 0 ? "path doesn't start with a slash: ".concat(string) : new String("path doesn't start with a slash: "));
        }
        String protocol = this.port == 443 ? "https" : "http";
        String string = this.hostname;
        int n = this.port;
        return new StringBuilder(15 + String.valueOf(protocol).length() + String.valueOf(string).length() + String.valueOf(path).length()).append(protocol).append("://").append(string).append(":").append(n).append(path).toString();
    }

    List<String[]> getHeadersBase() {
        ArrayList<String[]> headers = new ArrayList<String[]>();
        headers.add(new String[]{"Host", this.hostname});
        headers.add(new String[]{"X-appcfg-api-version", "1"});
        return headers;
    }
}

