/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.Transaction;

public class TransactionManager {
    private boolean containerManagedConnections = false;
    private Map<Object, Transaction> transactions = new ConcurrentHashMap<Object, Transaction>();

    public void setContainerManagedConnections(boolean flag) {
        this.containerManagedConnections = flag;
    }

    public void begin(Object om) {
        if (this.transactions.get(om) != null) {
            throw new NucleusTransactionException("Invalid state. Transaction has already started");
        }
        this.transactions.put(om, new Transaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Object om) {
        Transaction tx = this.transactions.get(om);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        try {
            if (!this.containerManagedConnections) {
                tx.commit();
            }
        }
        finally {
            this.transactions.remove(om);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Object om) {
        Transaction tx = this.transactions.get(om);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        try {
            if (!this.containerManagedConnections) {
                tx.rollback();
            }
        }
        finally {
            this.transactions.remove(om);
        }
    }

    public Transaction getTransaction(Object om) {
        if (om == null) {
            return null;
        }
        return this.transactions.get(om);
    }

    public void setRollbackOnly(Object om) {
        Transaction tx = this.transactions.get(om);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(Object om, int millis) {
        throw new UnsupportedOperationException();
    }

    public void resume(Object om, Transaction tx) {
        throw new UnsupportedOperationException();
    }

    public Transaction suspend(Object om) {
        throw new UnsupportedOperationException();
    }
}

