/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Service;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ServiceManager;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.DoNotMock;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Qualifier;

@GoogleInternal
@GwtIncompatible
public class ServiceModule
extends AbstractModule {
    private static final Module INTERNAL = new AbstractModule(){

        protected void configure() {
        }

        @Provides
        @Singleton
        ServiceManager provideServiceManager(Set<Service> services, @Internal Map<Integer, ServiceManager.Listener> listeners, @Internal Map<Integer, Executor> executors) {
            ServiceManager manager = new ServiceManager(services);
            for (Pair<Map.Entry<Integer, ServiceManager.Listener>, Map.Entry<Integer, Executor>> pair : Iterables.pairUp(listeners.entrySet(), executors.entrySet())) {
                if (!((Integer)((Map.Entry)pair.first).getKey()).equals(((Map.Entry)pair.second).getKey())) {
                    throw new AssertionError();
                }
                manager.addListener((ServiceManager.Listener)((Map.Entry)pair.first).getValue(), (Executor)((Map.Entry)pair.second).getValue());
            }
            return manager;
        }
    };
    private Multibinder<Service> serviceMultibinder;
    private MapBinder<Integer, ServiceManager.Listener> serviceManagerListeners;
    private MapBinder<Integer, Executor> serviceManagerExecutors;
    private static final AtomicInteger index = new AtomicInteger();

    protected final void configure() {
        this.install(INTERNAL);
        Binder userBinder = this.binder().skipSources(new Class[]{ServiceModule.class});
        this.serviceManagerExecutors = MapBinder.newMapBinder((Binder)userBinder, Integer.class, Executor.class, Internal.class);
        this.serviceManagerListeners = MapBinder.newMapBinder((Binder)userBinder, Integer.class, ServiceManager.Listener.class, Internal.class);
        this.serviceMultibinder = Multibinder.newSetBinder((Binder)userBinder, Service.class);
        this.configureServices();
        this.serviceMultibinder = null;
        this.serviceManagerListeners = null;
        this.serviceManagerExecutors = null;
    }

    public static ServiceModule forService(Class<? extends Service> service) {
        return ServiceModule.forService((Key<? extends Service>)Key.get(service));
    }

    public static ServiceModule forService(Key<? extends Service> key) {
        return new SingleServiceModule(key);
    }

    protected final LinkedBindingBuilder<Service> bindService() {
        return this.serviceMultibinder.addBinding();
    }

    protected final ListenerExecutorBindingBuilder bindServiceManagerListener() {
        int id = index.getAndIncrement();
        return new ListenerExecutorBindingBuilder(this.serviceManagerListeners.addBinding((Object)id), this.serviceManagerExecutors.addBinding((Object)id));
    }

    protected void configureServices() {
    }

    public static class ListenerExecutorBindingBuilder
    implements ListenerBindingBuilder {
        private static final ExecutorAdder DEFAULT = new ExecutorAdder(){

            @Override
            public void addTo(LinkedBindingBuilder<Executor> executorDelegate) {
                executorDelegate.toInstance((Object)MoreExecutors.directExecutor());
            }
        };
        private final LinkedBindingBuilder<ServiceManager.Listener> listenerDelegate;
        private final LinkedBindingBuilder<Executor> executorDelegate;
        private ExecutorAdder executor = DEFAULT;

        private ListenerExecutorBindingBuilder(LinkedBindingBuilder<ServiceManager.Listener> listenerDelegate, LinkedBindingBuilder<Executor> executorDelegate) {
            this.listenerDelegate = listenerDelegate;
            this.executorDelegate = executorDelegate;
        }

        @CanIgnoreReturnValue
        public ListenerBindingBuilder withExecutor(final Executor executor) {
            Preconditions.checkNotNull(executor);
            Preconditions.checkState(this.executor == DEFAULT, "An executor was already specified.");
            this.executor = new ExecutorAdder(this){

                @Override
                public void addTo(LinkedBindingBuilder<Executor> executorDelegate) {
                    executorDelegate.toInstance((Object)executor);
                }
            };
            return this;
        }

        @CanIgnoreReturnValue
        public ListenerBindingBuilder withExecutor(final Key<? extends Executor> executorKey) {
            Preconditions.checkNotNull(executorKey);
            Preconditions.checkState(this.executor == DEFAULT, "An executor was already specified.");
            this.executor = new ExecutorAdder(this){

                @Override
                public void addTo(LinkedBindingBuilder<Executor> executorDelegate) {
                    executorDelegate.to(executorKey);
                }
            };
            return this;
        }

        @CanIgnoreReturnValue
        public ListenerBindingBuilder withExecutor(final Provider<? extends Executor> executorProvider) {
            Preconditions.checkNotNull(executorProvider);
            Preconditions.checkState(this.executor == DEFAULT, "An executor was already specified.");
            this.executor = new ExecutorAdder(this){

                @Override
                public void addTo(LinkedBindingBuilder<Executor> executorDelegate) {
                    executorDelegate.toProvider(executorProvider);
                }
            };
            return this;
        }

        @Override
        public void to(TypeLiteral<? extends ServiceManager.Listener> implementation) {
            this.listenerDelegate.to(implementation);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public void to(Class<? extends ServiceManager.Listener> implementation) {
            this.listenerDelegate.to(implementation);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public void to(Key<? extends ServiceManager.Listener> targetKey) {
            this.listenerDelegate.to(targetKey);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public void toInstance(ServiceManager.Listener instance) {
            this.listenerDelegate.toInstance((Object)instance);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public void toProvider(Provider<? extends ServiceManager.Listener> provider) {
            this.listenerDelegate.toProvider(provider);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public void toProvider(Class<? extends javax.inject.Provider<? extends ServiceManager.Listener>> providerType) {
            this.listenerDelegate.toProvider(providerType);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public void toProvider(TypeLiteral<? extends javax.inject.Provider<? extends ServiceManager.Listener>> providerType) {
            this.listenerDelegate.toProvider(providerType);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public void toProvider(Key<? extends javax.inject.Provider<? extends ServiceManager.Listener>> providerKey) {
            this.listenerDelegate.toProvider(providerKey);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public <S extends ServiceManager.Listener> void toConstructor(Constructor<S> constructor) {
            this.listenerDelegate.toConstructor(constructor);
            this.executor.addTo(this.executorDelegate);
        }

        @Override
        public <S extends ServiceManager.Listener> void toConstructor(Constructor<S> constructor, TypeLiteral<? extends S> type) {
            this.listenerDelegate.toConstructor(constructor, type);
            this.executor.addTo(this.executorDelegate);
        }

        private static interface ExecutorAdder {
            public void addTo(LinkedBindingBuilder<Executor> var1);
        }
    }

    @DoNotMock(value="Use ServiceModule.bindServiceManagerListener")
    public static interface ListenerBindingBuilder {
        public void to(TypeLiteral<? extends ServiceManager.Listener> var1);

        public void to(Class<? extends ServiceManager.Listener> var1);

        public void to(Key<? extends ServiceManager.Listener> var1);

        public void toInstance(ServiceManager.Listener var1);

        public void toProvider(Provider<? extends ServiceManager.Listener> var1);

        public void toProvider(Class<? extends javax.inject.Provider<? extends ServiceManager.Listener>> var1);

        public void toProvider(TypeLiteral<? extends javax.inject.Provider<? extends ServiceManager.Listener>> var1);

        public void toProvider(Key<? extends javax.inject.Provider<? extends ServiceManager.Listener>> var1);

        public <S extends ServiceManager.Listener> void toConstructor(Constructor<S> var1);

        public <S extends ServiceManager.Listener> void toConstructor(Constructor<S> var1, TypeLiteral<? extends S> var2);
    }

    private static final class SingleServiceModule
    extends ServiceModule {
        final Key<? extends Service> key;

        SingleServiceModule(Key<? extends Service> key) {
            this.key = Preconditions.checkNotNull(key);
        }

        @Override
        protected void configureServices() {
            this.bindService().to(this.key);
        }

        public boolean equals(Object obj) {
            return obj instanceof SingleServiceModule && ((SingleServiceModule)((Object)obj)).key.equals(this.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.key);
            return new StringBuilder(15 + String.valueOf(string).length()).append("ServiceModule[").append(string).append("]").toString();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    private static @interface Internal {
    }
}

