/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import javax.annotation.concurrent.GuardedBy;

public class InstanceStateHolder {
    private static final Joiner STATE_JOINER = Joiner.on("|");
    private final String moduleOrBackendName;
    private final int instance;
    @GuardedBy(value="this")
    private InstanceState currentState = InstanceState.SHUTDOWN;

    InstanceStateHolder(String moduleOrBackendName, int instance) {
        this.moduleOrBackendName = moduleOrBackendName;
        this.instance = instance;
    }

    void testAndSet(InstanceState newState, InstanceState ... acceptablePreviousStates) throws IllegalStateException {
        InstanceState invalidState = this.testAndSetIf(newState, acceptablePreviousStates);
        if (invalidState != null) {
            InstanceStateHolder.reportInvalidStateChange(this.moduleOrBackendName, this.instance, invalidState, newState, acceptablePreviousStates);
        }
    }

    static void reportInvalidStateChange(String moduleOrBackendName, int instance, InstanceState currentState, InstanceState newState, InstanceState ... acceptablePreviousStates) {
        StringBuilder error = new StringBuilder();
        String string = String.valueOf((Object)newState);
        error.append(new StringBuilder(25 + String.valueOf(string).length()).append("Tried to change state to ").append(string).toString());
        error.append(new StringBuilder(23 + String.valueOf(moduleOrBackendName).length()).append(" on module ").append(moduleOrBackendName).append(".").append(instance).toString());
        string = String.valueOf((Object)currentState);
        error.append(new StringBuilder(23 + String.valueOf(string).length()).append(" but previous state is ").append(string).toString());
        error.append(" and not ");
        error.append(STATE_JOINER.join((Object[])acceptablePreviousStates));
        throw new IllegalStateException(error.toString());
    }

    synchronized InstanceState testAndSetIf(InstanceState newState, InstanceState ... acceptablePreviousStates) {
        InstanceState result = this.currentState;
        if (this.test(acceptablePreviousStates)) {
            result = null;
            this.currentState = newState;
        }
        return result;
    }

    synchronized boolean test(InstanceState ... acceptableStates) {
        for (InstanceState acceptable : acceptableStates) {
            if (this.currentState != acceptable) continue;
            return true;
        }
        return false;
    }

    synchronized void requireState(String operation, InstanceState ... acceptableStates) {
        if (!this.test(acceptableStates)) {
            String string = String.valueOf((Object)this.currentState);
            String string2 = STATE_JOINER.join((Object[])acceptableStates);
            throw new IllegalStateException(new StringBuilder(64 + String.valueOf(operation).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid current state operation=").append(operation).append(" currentState=").append(string).append(" acceptableStates=").append(string2).toString());
        }
    }

    synchronized boolean acceptsConnections() {
        return this.currentState == InstanceState.RUNNING || this.currentState == InstanceState.RUNNING_START_REQUEST || this.currentState == InstanceState.SLEEPING;
    }

    synchronized String getDisplayName() {
        return this.currentState.name().toLowerCase();
    }

    synchronized void set(InstanceState newState) {
        this.currentState = newState;
    }

    static enum InstanceState {
        INITIALIZING,
        SLEEPING,
        RUNNING_START_REQUEST,
        RUNNING,
        STOPPED,
        SHUTDOWN;

    }
}

