/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.jetty9;

import com.google.apphosting.api.ApiProxy;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Logger;

public class JettyLogger
extends JavaUtilLog {
    private static boolean logToApiProxy = Boolean.getBoolean("appengine.jetty.also_log_to_apiproxy");

    public JettyLogger() {
        this(null);
    }

    public JettyLogger(String name) {
        super(new StringBuilder(13 + String.valueOf(name).length()).append("JettyLogger(").append(name).append(")").toString());
    }

    public void warn(String msg, Throwable th) {
        super.warn(msg, th);
        if (logToApiProxy && ApiProxy.getCurrentEnvironment() != null && th != null) {
            ApiProxy.log((ApiProxy.LogRecord)this.createLogRecord(msg, th));
        }
    }

    protected Logger newLogger(String name) {
        return new JettyLogger(name);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    private ApiProxy.LogRecord createLogRecord(String message, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        if (ex != null) {
            ex.printStackTrace(printWriter);
        }
        return new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.warn, System.currentTimeMillis() * 1000L, stringWriter.toString());
    }
}

