/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DispatchXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.File;
import java.io.InputStream;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class DispatchXmlReader
extends AbstractConfigXmlReader<DispatchXml> {
    public static final String DEFAULT_RELATIVE_FILENAME;
    private static final String DISPATCH_ENTRIES_TAG = "dispatch-entries";
    private static final String DISPATCH_TAG = "dispatch";
    private static final String URL_TAG = "url";
    private static final String MODULE_TAG = "module";
    private final String relativeFilename;
    private static final ImmutableSet<String> DISPATCH_TAGS;

    public DispatchXmlReader(String warDirectory, String relativeFilename) {
        super(warDirectory, false);
        this.relativeFilename = relativeFilename;
    }

    @Override
    protected String getRelativeFilename() {
        return this.relativeFilename;
    }

    public DispatchXml readDispatchXml() {
        return (DispatchXml)this.readConfigXml();
    }

    @Override
    protected DispatchXml processXml(InputStream is) {
        Element root = XmlUtils.parseXml(is, this.getFilename()).getDocumentElement();
        if (!DISPATCH_ENTRIES_TAG.equals(root.getTagName())) {
            this.throwExpectingTag(DISPATCH_ENTRIES_TAG, root.getTagName());
        }
        DispatchXml.Builder dispatchXmlBuilder = DispatchXml.builder();
        for (Element child : XmlUtils.getChildren(root)) {
            if (child.getTagName().equals(DISPATCH_TAG)) {
                dispatchXmlBuilder.addDispatchEntry(this.parseDispatchEntry(child));
                continue;
            }
            this.throwExpectingTag(DISPATCH_TAG, child.getTagName());
        }
        return dispatchXmlBuilder.build();
    }

    private DispatchXml.DispatchEntry parseDispatchEntry(Element dispatchElement) {
        TreeMap<String, String> tagValues = new TreeMap<String, String>();
        for (Element child : XmlUtils.getChildren(dispatchElement)) {
            String tag = child.getTagName();
            if (DISPATCH_TAGS.contains(tag)) {
                if (tagValues.containsKey(tag)) {
                    this.throwDuplicateTag(tag, DISPATCH_TAG);
                    continue;
                }
                tagValues.put(tag, this.stringContents(child));
                continue;
            }
            this.throwUnsupportedTag(tag, DISPATCH_TAG);
        }
        for (String tag : DISPATCH_TAGS) {
            if (tagValues.containsKey(tag)) continue;
            this.throwExpectingTag(tag, "/dispatch");
        }
        return new DispatchXml.DispatchEntry((String)tagValues.get(URL_TAG), (String)tagValues.get(MODULE_TAG));
    }

    private void throwExpectingTag(String expecting, String got) {
        throw new AppEngineConfigException(String.format("Expecting <%s> but got <%s> in file %s", expecting, got, this.getFilename()));
    }

    private void throwDuplicateTag(String duplicateTag, String parentTag) {
        if (parentTag == null) {
            throw new AppEngineConfigException(String.format("Duplicate <%s> in file %s", duplicateTag, this.getFilename()));
        }
        throw new AppEngineConfigException(String.format("Duplicate <%s> inside <%s> in file %s", duplicateTag, parentTag, this.getFilename()));
    }

    private void throwUnsupportedTag(String tag, String parent) {
        throw new AppEngineConfigException(String.format("Tag <%s> not supported in element <%s> in file %s", tag, parent, this.getFilename()));
    }

    static {
        char c = File.separatorChar;
        DEFAULT_RELATIVE_FILENAME = new StringBuilder(20).append("WEB-INF").append(c).append("dispatch.xml").toString();
        DISPATCH_TAGS = ImmutableSet.of(URL_TAG, MODULE_TAG);
    }
}

