/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncCloudDatastoreV1ServiceImpl;
import com.google.appengine.api.datastore.AsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.AsyncDatastoreServiceInternal;
import com.google.appengine.api.datastore.CloudDatastoreV1ClientImpl;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceGlobalConfig;
import com.google.appengine.api.datastore.DatastoreServiceImpl;
import com.google.appengine.api.datastore.IDatastoreServiceFactory;
import com.google.appengine.api.datastore.TransactionStackImpl;

final class DatastoreServiceFactoryImpl
implements IDatastoreServiceFactory {
    DatastoreServiceFactoryImpl() {
    }

    @Override
    public DatastoreService getDatastoreService(DatastoreServiceConfig config) {
        return new DatastoreServiceImpl(this.getAsyncDatastoreService(config));
    }

    @Override
    public AsyncDatastoreServiceInternal getAsyncDatastoreService(DatastoreServiceConfig config) {
        TransactionStackImpl txnStack = new TransactionStackImpl();
        if (DatastoreServiceGlobalConfig.getConfig().useApiProxy()) {
            return new AsyncDatastoreServiceImpl(config, config.constructApiConfig(), txnStack);
        }
        return new AsyncCloudDatastoreV1ServiceImpl(config, CloudDatastoreV1ClientImpl.create(config), txnStack);
    }
}

