/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.AppEngineSocketImplFactory;
import com.google.appengine.api.socket.AppEngineSocketOptions;
import com.google.appengine.api.socket.AppEngineSocketOptionsClient;
import com.google.appengine.api.socket.AppEngineSocketUtils;
import com.google.appengine.api.socket.SocketApiHelper;
import com.google.appengine.api.socket.SocketServicePb;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Arrays;

class AppEngineDatagramSocketImpl
extends DatagramSocketImpl
implements AppEngineSocketOptionsClient,
Serializable {
    private SocketApiHelper socketHelper = null;
    String descriptor;
    volatile int timeout = -1;

    AppEngineDatagramSocketImpl() {
    }

    AppEngineDatagramSocketImpl(SocketApiHelper socketHelper) {
        this.socketHelper = socketHelper;
    }

    SocketApiHelper getSocketApiHelper() {
        return this.socketHelper == null ? AppEngineSocketImplFactory.SOCKET_API_HELPER : this.socketHelper;
    }

    void setOption(AppEngineSocketOptions.Option option, Object value) throws SocketException {
        this.checkNotClosed();
        option.validateAndApply(this, value);
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setSocketOptionAsBytes(AppEngineSocketOptions.Option option, byte[] value) throws SocketException {
        SocketServicePb.SocketOption.SocketOptionName name = option.getOptName();
        if (name == null) {
            return;
        }
        SocketServicePb.SetSocketOptionsRequest request = new SocketServicePb.SetSocketOptionsRequest();
        request.setSocketDescriptor(this.descriptor);
        request.addOptions().setLevel(option.getLevel()).setOption(name).setValueAsBytes(value);
        this.getSocketApiHelper().makeSyncCall("SetSocketOptions", request, new SocketServicePb.SetSocketOptionsReply(), null);
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        AppEngineSocketOptions.Option option = AppEngineSocketOptions.getOptionById(optID);
        if (option == null) {
            throw new SocketException(new StringBuilder(39).append("unrecognized socket option: ").append(optID).toString());
        }
        this.setOption(option, value);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        if (4102 == optID) {
            this.checkNotClosed();
            return this.timeout < 0 ? Integer.MAX_VALUE : this.timeout;
        }
        AppEngineSocketOptions.Option option = AppEngineSocketOptions.getOptionById(optID);
        if (option == null) {
            throw new SocketException(new StringBuilder(39).append("unrecognized socket option: ").append(optID).toString());
        }
        return this.getOption(option);
    }

    private Object getOption(AppEngineSocketOptions.Option option) throws SocketException {
        return option.getOption(this);
    }

    @Override
    public byte[] getSocketOptionAsBytes(AppEngineSocketOptions.Option option) throws SocketException {
        this.checkNotClosed();
        switch (option) {
            case SO_BINDADDR_OPT: {
                SocketServicePb.GetSocketNameRequest request = new SocketServicePb.GetSocketNameRequest();
                SocketServicePb.GetSocketNameReply response = new SocketServicePb.GetSocketNameReply();
                request.setSocketDescriptor(this.descriptor);
                this.getSocketApiHelper().makeSyncCall("GetSocketName", request, response, null);
                return response.getProxyExternalIp().getPackedAddressAsBytes();
            }
        }
        SocketServicePb.GetSocketOptionsRequest request = new SocketServicePb.GetSocketOptionsRequest();
        SocketServicePb.GetSocketOptionsReply response = new SocketServicePb.GetSocketOptionsReply();
        request.setSocketDescriptor(this.descriptor);
        request.addOptions().setLevel(option.getLevel()).setOption(option.getOptName());
        this.getSocketApiHelper().makeSyncCall("GetSocketOptions", request, response, null);
        return response.optionss().get(0).getValueAsBytes();
    }

    private void checkNotClosed() throws SocketException {
        if (this.descriptor == null) {
            throw new SocketException("socket closed");
        }
    }

    @Override
    protected void create() throws SocketException {
        if (this.descriptor != null) {
            throw new SocketException("create may not be called on an already created socket.");
        }
        SocketServicePb.CreateSocketRequest request = new SocketServicePb.CreateSocketRequest();
        SocketServicePb.CreateSocketReply response = new SocketServicePb.CreateSocketReply();
        request.setFamily(SocketServicePb.CreateSocketRequest.SocketFamily.IPv6);
        request.setProtocol(SocketServicePb.CreateSocketRequest.SocketProtocol.UDP);
        this.getSocketApiHelper().makeSyncCall("CreateSocket", request, response, null);
        this.descriptor = response.getSocketDescriptor();
    }

    @Override
    protected void bind(int lport, InetAddress laddr) throws SocketException {
        this.checkNotClosed();
        SocketServicePb.BindRequest request = new SocketServicePb.BindRequest().setSocketDescriptor(this.descriptor);
        request.setProxyExternalIp(AppEngineSocketUtils.toAddressPort(laddr, lport));
        this.getSocketApiHelper().makeSyncCall("Bind", request, new SocketServicePb.BindReply(), null);
    }

    @Override
    protected void send(DatagramPacket p) throws IOException {
        this.checkNotClosed();
        byte[] bytes = p.getData();
        int off = p.getOffset();
        int len = p.getLength();
        if (bytes.length != len || off != 0) {
            bytes = Arrays.copyOfRange(bytes, off, off + len);
        }
        SocketServicePb.SendRequest request = new SocketServicePb.SendRequest().setSocketDescriptor(this.descriptor).setDataAsBytes(bytes);
        InetAddress addr = p.getAddress();
        if (addr != null) {
            request.setSendTo(AppEngineSocketUtils.toAddressPort(addr, p.getPort()));
        }
        if (this.timeout != -1) {
            request.setTimeoutSeconds((double)this.timeout * 0.001);
        }
        this.getSocketApiHelper().makeSyncCall("Send", request, new SocketServicePb.SendReply(), null);
    }

    @Override
    protected int peek(InetAddress i) throws IOException {
        throw new SocketException("#peek(InetAddress) is not implemented.");
    }

    @Override
    protected int peekData(DatagramPacket p) throws IOException {
        this.checkNotClosed();
        this.receiveOrPeek(p, true);
        return p.getPort();
    }

    @Override
    protected void receive(DatagramPacket p) throws IOException {
        this.checkNotClosed();
        this.receiveOrPeek(p, false);
    }

    private void receiveOrPeek(DatagramPacket p, boolean isPeek) throws IOException {
        this.checkNotClosed();
        SocketServicePb.ReceiveReply response = new SocketServicePb.ReceiveReply();
        SocketServicePb.ReceiveRequest request = new SocketServicePb.ReceiveRequest().setSocketDescriptor(this.descriptor).setDataSize(p.getLength());
        if (this.timeout != -1) {
            request.setTimeoutSeconds((double)this.timeout * 0.001);
        }
        if (isPeek) {
            request.setFlags(SocketServicePb.ReceiveRequest.Flags.MSG_PEEK.getValue());
        }
        this.getSocketApiHelper().makeSyncCall("Receive", request, response, null);
        byte[] readBytes = response.getDataAsBytes();
        if (readBytes.length > 0) {
            System.arraycopy(readBytes, 0, p.getData(), p.getOffset(), readBytes.length);
        }
        p.setLength(readBytes.length);
        SocketServicePb.AddressPort addrPort = response.getReceivedFrom();
        p.setPort(addrPort.getPort());
        p.setAddress(InetAddress.getByAddress(addrPort.getPackedAddressAsBytes()));
    }

    @Override
    @Deprecated
    protected void setTTL(byte ttl) throws IOException {
        this.setTimeToLive(ttl);
    }

    @Override
    @Deprecated
    protected byte getTTL() throws IOException {
        return (byte)this.getTimeToLive();
    }

    @Override
    protected void setTimeToLive(int ttl) throws IOException {
        throw new SecurityException("App Engine does not allow multicast setTimeToLive");
    }

    @Override
    protected int getTimeToLive() throws IOException {
        throw new SecurityException("App Engine does not allow multicast getTimeToLive");
    }

    @Override
    protected void join(InetAddress inetaddr) throws IOException {
        throw new SecurityException("App Engine does not allow multicast join");
    }

    @Override
    protected void leave(InetAddress inetaddr) throws IOException {
        throw new SecurityException("App Engine does not allow multicast leave");
    }

    @Override
    protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        throw new SecurityException("App Engine does not allow multicast joinGroup");
    }

    @Override
    protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        throw new SecurityException("App Engine does not allow multicast leaveGroup");
    }

    @Override
    protected void close() {
        if (this.descriptor != null) {
            try {
                SocketServicePb.CloseRequest request = new SocketServicePb.CloseRequest().setSocketDescriptor(this.descriptor);
                this.getSocketApiHelper().makeSyncCall("Close", request, new SocketServicePb.CloseReply(), null);
            }
            catch (SocketException socketException) {
            }
            finally {
                this.descriptor = null;
            }
        }
    }
}

