/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.io;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.FluentIterable;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.io.ByteSource;
import com.google.appengine.repackaged.com.google.common.io.CharSource;
import com.google.appengine.repackaged.com.google.common.io.Closer;
import com.google.appengine.repackaged.com.google.common.io.FileWriteMode;
import com.google.appengine.repackaged.com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

@GoogleInternal
@GwtIncompatible
public final class ZipFiles {
    private ZipFiles() {
    }

    public static ByteSource asByteSource(ZipFile file, ZipEntry entry) {
        return new ZipEntryByteSource(file, entry);
    }

    public static CharSource asCharSource(ZipFile file, ZipEntry entry, Charset charset) {
        return ZipFiles.asByteSource(file, entry).asCharSource(charset);
    }

    public static FluentIterable<ZipEntry> entries(final ZipFile file) {
        Preconditions.checkNotNull(file);
        return new FluentIterable<ZipEntry>(){

            @Override
            public Iterator<ZipEntry> iterator() {
                return Iterators.forEnumeration(file.entries());
            }
        };
    }

    public static void unzipFile(File zipFile, File targetDirectory) throws IOException {
        ZipFiles.unzipFile(zipFile, targetDirectory, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File zipFile, File targetDirectory, Charset charset) throws IOException {
        Preconditions.checkNotNull(zipFile);
        Preconditions.checkNotNull(targetDirectory);
        Preconditions.checkNotNull(charset);
        Preconditions.checkArgument(targetDirectory.isDirectory(), "%s is not a valid directory", (Object)targetDirectory.getAbsolutePath());
        try (ZipFile zipFileObj = new ZipFile(zipFile, charset);){
            for (ZipEntry entry : ZipFiles.entries(zipFileObj)) {
                ZipFiles.checkName(entry.getName());
                File targetFile = new File(targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (targetFile.isDirectory() || targetFile.mkdirs()) continue;
                    String string = String.valueOf(targetFile.getAbsolutePath());
                    throw new IOException(string.length() != 0 ? "Failed to create directory: ".concat(string) : new String("Failed to create directory: "));
                }
                File parentFile = targetFile.getParentFile();
                if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                    String string = String.valueOf(parentFile.getAbsolutePath());
                    throw new IOException(string.length() != 0 ? "Failed to create directory: ".concat(string) : new String("Failed to create directory: "));
                }
                ZipFiles.asByteSource(zipFileObj, entry).copyTo(Files.asByteSink(targetFile, new FileWriteMode[0]));
            }
        }
    }

    private static void checkName(String name) throws IOException {
        if (name.contains("..")) {
            for (File file = new File(name); file != null; file = file.getParentFile()) {
                if (!file.getName().equals("..")) continue;
                String string = String.valueOf(name);
                throw new IOException(string.length() != 0 ? "Cannot unzip file containing an entry with \"..\" in the name: ".concat(string) : new String("Cannot unzip file containing an entry with \"..\" in the name: "));
            }
        }
    }

    public static void zipDirectory(File sourceDirectory, File zipFile) throws IOException {
        Preconditions.checkNotNull(sourceDirectory);
        Preconditions.checkNotNull(zipFile);
        Preconditions.checkArgument(sourceDirectory.isDirectory(), "%s is not a valid directory", (Object)sourceDirectory.getAbsolutePath());
        Preconditions.checkArgument(!zipFile.exists(), "%s does already exist, files are not being overwritten", (Object)zipFile.getAbsolutePath());
        try (Closer closer = Closer.create();){
            OutputStream outputStream = closer.register(new BufferedOutputStream(new FileOutputStream(zipFile)));
            ZipFiles.zipDirectory(sourceDirectory, outputStream);
        }
    }

    public static void zipDirectory(File sourceDirectory, OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull(sourceDirectory);
        Preconditions.checkNotNull(outputStream);
        Preconditions.checkArgument(sourceDirectory.isDirectory(), "%s is not a valid directory", (Object)sourceDirectory.getAbsolutePath());
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        for (File file : sourceDirectory.listFiles()) {
            ZipFiles.zipDirectoryInternal(file, "", zos);
        }
        zos.finish();
    }

    private static void zipDirectoryInternal(File inputFile, String directoryName, ZipOutputStream zos) throws IOException {
        String entryName;
        if ("".equals(directoryName)) {
            entryName = inputFile.getName();
        } else {
            String string = inputFile.getName();
            entryName = new StringBuilder(1 + String.valueOf(directoryName).length() + String.valueOf(string).length()).append(directoryName).append("/").append(string).toString();
        }
        if (inputFile.isDirectory()) {
            if (inputFile.list().length == 0) {
                ZipEntry zipEntry = new ZipEntry(String.valueOf(entryName).concat("/"));
                zos.putNextEntry(zipEntry);
            } else {
                for (File file : inputFile.listFiles()) {
                    ZipFiles.zipDirectoryInternal(file, entryName, zos);
                }
            }
        } else {
            ZipEntry zipEntry = new ZipEntry(entryName);
            zos.putNextEntry(zipEntry);
            Files.asByteSource(inputFile).copyTo(zos);
        }
    }

    private static final class ZipEntryByteSource
    extends ByteSource {
        private final ZipFile file;
        private final ZipEntry entry;

        ZipEntryByteSource(ZipFile file, ZipEntry entry) {
            this.file = Preconditions.checkNotNull(file);
            this.entry = Preconditions.checkNotNull(entry);
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        public String toString() {
            String string = String.valueOf(this.file);
            String string2 = String.valueOf(this.entry);
            return new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ZipFiles.asByteSource(").append(string).append(", ").append(string2).append(")").toString();
        }
    }
}

