/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.api.server.spi.tools.GenApiConfigAction;
import com.google.api.server.spi.tools.GenClientLibAction;
import com.google.api.server.spi.tools.GenDiscoveryDocAction;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class GetClientLibAction
extends EndpointsToolAction {
    public static final String NAME = "get-client-lib";
    private Option classPathOption = this.makeClassPathOption();
    private Option languageOption = this.makeLanguageOption();
    private Option outputOption = this.makeOutputOption();
    private Option warOption = this.makeWarOption();
    private Option buildSystemOption = this.makeBuildSystemOption();
    private Option debugOption = this.makeDebugOption();

    public GetClientLibAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.classPathOption, this.languageOption, this.outputOption, this.warOption, this.buildSystemOption, this.debugOption));
        this.setShortDescription("Generates a client library");
        this.setExampleString("<Endpoints tool> get-client-lib --language=java --build_system=maven com.google.devrel.samples.ttt.spi.BoardV1 com.google.devrel.samples.ttt.spi.ScoresV1");
        this.setHelpDisplayNeeded(true);
    }

    @Override
    public boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        if (this.getArgs().isEmpty()) {
            return false;
        }
        String warPath = this.getWarPath(this.warOption);
        this.getClientLib(this.computeClassPath(warPath, this.getClassPath(this.classPathOption)), this.getLanguage(this.languageOption), this.getOutputPath(this.outputOption), warPath, this.getArgs(), this.getBuildSystem(this.buildSystemOption), this.getDebug(this.debugOption));
        return true;
    }

    public Object getClientLib(URL[] classPath, String language, String outputDirPath, String warPath, List<String> serviceClassNames, String buildSystem, boolean debug) throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        Iterable<String> apiConfigs = new GenApiConfigAction().genApiConfig(classPath, outputDirPath, warPath, serviceClassNames, debug);
        for (String apiConfig : apiConfigs) {
            String restDiscoveryDocPath = new GenDiscoveryDocAction().genDiscoveryDoc(DiscoveryDocGenerator.Format.REST, outputDirPath, apiConfig, debug);
            new GenClientLibAction().genClientLib(language, outputDirPath, restDiscoveryDocPath, buildSystem);
        }
        return null;
    }

    @Override
    public String getUsageString() {
        return "get-client-lib <options> <service class>...";
    }
}

