/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.api.server.spi.tools.GenApiConfigAction;
import com.google.api.server.spi.tools.GenDiscoveryDocAction;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class GetDiscoveryDocAction
extends EndpointsToolAction {
    public static final String NAME = "get-discovery-doc";
    private Option classPathOption = this.makeClassPathOption();
    private Option outputOption = this.makeOutputOption();
    private Option warOption = this.makeWarOption();
    private Option debugOption = this.makeDebugOption();
    private Option formatOption = this.makeFormatOption();

    public GetDiscoveryDocAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.classPathOption, this.formatOption, this.outputOption, this.warOption, this.debugOption));
        this.setShortDescription("Generates discovery documents");
        this.setExampleString("<Endpoints tool> get-discovery-doc --format=rpc com.google.devrel.samples.ttt.spi.BoardV1 com.google.devrel.samples.ttt.spi.ScoresV1");
        this.setHelpDisplayNeeded(true);
    }

    @Override
    public boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        if (this.getArgs().isEmpty()) {
            return false;
        }
        String warPath = this.getWarPath(this.warOption);
        DiscoveryDocGenerator.Format format = DiscoveryDocGenerator.Format.valueOf(this.getFormat(this.formatOption).toUpperCase());
        this.getDiscoveryDoc(format, this.computeClassPath(warPath, this.getClassPath(this.classPathOption)), this.getOutputPath(this.outputOption), warPath, this.getArgs(), this.getDebug(this.debugOption));
        return true;
    }

    public Iterable<String> getDiscoveryDoc(DiscoveryDocGenerator.Format format, URL[] classPath, String outputDirPath, String warPath, List<String> serviceClassNames, boolean debug) throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        Iterable<String> apiConfigs = new GenApiConfigAction().genApiConfig(classPath, outputDirPath, warPath, serviceClassNames, debug);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String apiConfig : apiConfigs) {
            builder.add(this.generateDiscoveryDocs(format, outputDirPath, apiConfig));
        }
        return builder.build();
    }

    @VisibleForTesting
    String generateDiscoveryDocs(DiscoveryDocGenerator.Format format, String outputDirPath, String apiConfig) throws JsonParseException, JsonMappingException, IOException, FileNotFoundException {
        return this.generateDiscoveryDoc(format, outputDirPath, apiConfig);
    }

    @VisibleForTesting
    String generateDiscoveryDoc(DiscoveryDocGenerator.Format format, String outputDirPath, String apiConfig) throws JsonParseException, JsonMappingException, IOException, FileNotFoundException {
        return new GenDiscoveryDocAction().genDiscoveryDoc(format, outputDirPath, apiConfig, true);
    }

    @Override
    public String getUsageString() {
        return "get-discovery-doc <options> <service class>...";
    }
}

