/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metamodel;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.metamodel.ManagedTypeImpl;
import org.datanucleus.metadata.AbstractMemberMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeImpl<X, Y>
implements Attribute<X, Y> {
    AbstractMemberMetaData mmd;
    ManagedTypeImpl<X> owner;

    public AttributeImpl(AbstractMemberMetaData mmd, ManagedTypeImpl<X> owner) {
        this.mmd = mmd;
        this.owner = owner;
    }

    public AbstractMemberMetaData getMetadata() {
        return this.mmd;
    }

    public ManagedType<X> getDeclaringType() {
        Class ownerCls = this.owner.getModel().getClassLoaderResolver().classForName(this.mmd.getClassName(true));
        return this.owner.getModel().managedType(ownerCls);
    }

    public Member getJavaMember() {
        return this.mmd.getMemberRepresented();
    }

    public Class<Y> getJavaType() {
        return this.mmd.getType();
    }

    public String getName() {
        return this.mmd.getName();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        int relationType = this.mmd.getRelationType(this.owner.getModel().getClassLoaderResolver());
        switch (relationType) {
            case 6: {
                return Attribute.PersistentAttributeType.MANY_TO_ONE;
            }
            case 1: 
            case 2: {
                return Attribute.PersistentAttributeType.ONE_TO_ONE;
            }
            case 3: 
            case 4: {
                return Attribute.PersistentAttributeType.ONE_TO_MANY;
            }
            case 5: {
                return Attribute.PersistentAttributeType.MANY_TO_MANY;
            }
        }
        if (Collection.class.isAssignableFrom(this.mmd.getType())) {
            return Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
        }
        return Attribute.PersistentAttributeType.BASIC;
    }

    public boolean isAssociation() {
        int relationType = this.mmd.getRelationType(this.owner.getModel().getClassLoaderResolver());
        return relationType != 0;
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.mmd.getType()) || Map.class.isAssignableFrom(this.mmd.getType());
    }

    public final Type<Y> getType() {
        ClassLoaderResolver clr = this.owner.getModel().getClassLoaderResolver();
        if (Collection.class.isAssignableFrom(this.mmd.getType())) {
            String elementTypeName = this.mmd.getCollection().getElementType();
            return this.owner.model.getType(clr.classForName(elementTypeName));
        }
        if (this.mmd.getType().isArray()) {
            return this.owner.model.managedType(this.mmd.getType().getComponentType());
        }
        return this.owner.model.getType(this.mmd.getType());
    }
}

