/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Expression for something being "in"/"not in" something else.
 */
public class InExpression extends BooleanExpression
{
    ScalarExpression expr1;
    ScalarExpression expr2;

    /**
     * Constructor for expr1 being IN expr2.
     * @param op the operator (OP_IN, OP_NOTIN)
     * @param expr1 the expression being contained
     * @param expr2 the expression that contains
     */
    public InExpression(ScalarExpression expr1, DyadicOperator op, ScalarExpression expr2)
    {
        super(expr1, op, expr2);
        this.expr1 = expr1;
        this.expr2 = expr2;
    }

    /**
     * Method to return a boolean expression for expr1 NOT IN expr2.
     * @return The boolean expression for NOT IN
     */
    public BooleanExpression not()
    {
        return new InExpression(expr1, OP_NOTIN, expr2);
    }
}