/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.jpa;

import org.datanucleus.identity.ByteIdentity;
import org.datanucleus.identity.CharIdentity;
import org.datanucleus.identity.IntIdentity;
import org.datanucleus.identity.LongIdentity;
import org.datanucleus.identity.ObjectIdentity;
import org.datanucleus.identity.ShortIdentity;
import org.datanucleus.identity.StringIdentity;

/**
 * Class providing names of common classes used by JPA to aid performance.
 */
public class JPAClassNameConstants
{
    /** org.datanucleus.identity.LongIdentity **/
    public static final String JPA_IDENTITY_LONG_IDENTITY = LongIdentity.class.getName();

    /** org.datanucleus.identity.IntIdentity **/
    public static final String JPA_IDENTITY_INT_IDENTITY = IntIdentity.class.getName();

    /** org.datanucleus.identity.StringIdentity **/
    public static final String JPA_IDENTITY_STRING_IDENTITY = StringIdentity.class.getName();

    /** org.datanucleus.identity.CharIdentity **/
    public static final String JPA_IDENTITY_CHAR_IDENTITY = CharIdentity.class.getName();

    /** org.datanucleus.identity.ByteIdentity **/
    public static final String JPA_IDENTITY_BYTE_IDENTITY = ByteIdentity.class.getName();

    /** org.datanucleus.identity.ObjectIdentity **/
    public static final String JPA_IDENTITY_OBJECT_IDENTITY = ObjectIdentity.class.getName();

    /** org.datanucleus.identity.ShortIdentity **/
    public static final String JPA_IDENTITY_SHORT_IDENTITY = ShortIdentity.class.getName();

    /** org.datanucleus.jpa.Persistable **/
    public static final String JAVAX_JDO_SPI_PERSISTENCE_CAPABLE = Persistable.class.getName();
}
