// Copyright 2012 Google Inc. All rights reserved.
package com.google.appengine.api.capabilities;

import com.google.appengine.spi.FactoryProvider;
import com.google.appengine.spi.ServiceProvider;
import com.google.auto.service.AutoService;

/**
 * Factory provider for {@link ICapabilitiesServiceFactory}.
 *
 * <p><b>Note:</b> This class is not intended for end users.
 *
 */
@AutoService(FactoryProvider.class)
@ServiceProvider(precedence = Integer.MIN_VALUE)
public final class ICapabilitiesServiceFactoryProvider
    extends FactoryProvider<ICapabilitiesServiceFactory> {

  private final CapabilitiesServiceFactoryImpl implementation
      = new CapabilitiesServiceFactoryImpl();

  public ICapabilitiesServiceFactoryProvider() {
    super(ICapabilitiesServiceFactory.class);
  }

  @Override
  protected ICapabilitiesServiceFactory getFactoryInstance() {
    return implementation;
  }

}
