package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CloudDatastoreRemoteServiceConfig.AppId.Location;
import com.google.common.collect.ImmutableBiMap;
import javax.annotation.Nullable;

class LocationMapper {

  private static final ImmutableBiMap<String, Location> locationByPartitionId =
      ImmutableBiMap.<String, Location>builder()
          .put("b", Location.ASIA_NORTHEAST1)
          .put("d", Location.US_EAST4)
          .put("e", Location.EUROPE_WEST)
          .put("f", Location.AUSTRALIA_SOUTHEAST1)
          .put("g", Location.EUROPE_WEST1)
          .put("h", Location.EUROPE_WEST3)
          .put("p", Location.US_EAST1)
          .put("s", Location.US_CENTRAL)
          .build();

  @Nullable
  static Location getLocation(String partitionId) {
    return locationByPartitionId.get(partitionId);
  }

  @Nullable
  static String getPartitionId(Location location) {
    return locationByPartitionId.inverse().get(location);
  }
}
