/**********************************************************************
Copyright (c) 2004 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;


/**
 * Concatenate two expressions. This implements the SQL standard concatenation operator.
 * e.g. EXPR1 || EXPR2 
 *
 * @version $Revision: 1.8 $
 **/
public class ConcatOperatorExpression extends StringExpression
{
    /**
     * Performs a concatenation on two operands.
     * op(operand1,operand2)
     * operand1 op operand2 
     * @param operand1 the left-hand expression
     * @param operand2 the right-hand expression
     */    
    public ConcatOperatorExpression(ScalarExpression operand1, ScalarExpression operand2)
    {
        super(operand1.qs);
        if (ScalarExpression.OP_CONCAT.isHigherThanLeftSide(operand1.lowestOperator))
        {
            st.append('(').append(operand1).append(')');
        }
        else
        {
            st.append(operand1);
        }

        st.append(operand1.qs.getStoreManager().getDatastoreAdapter().getOperatorConcat());

        if (ScalarExpression.OP_CONCAT.isHigherThanRightSide(operand2.lowestOperator))
        {
            st.append('(').append(operand2).append(')');
        }
        else
        {
            st.append(operand2);
        }
    }
}
