/*
 * Decompiled with CFR 0.152.
 */
package ccl.platform;

import ccl.platform.Native;
import ccl.util.ClassPathUtil;
import ccl.util.FileUtil;
import ccl.util.Util;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;

public class Linux
extends Native {
    private static boolean _bLibLoaded = false;

    protected Linux() {
    }

    private static native int _symlink(String var0, String var1);

    private static native int _unlink(String var0);

    private static native int _getpid();

    private static native int _getpgid(int var0);

    public static String getWindowID(String sFrameName_) {
        return Linux.getWindowID(sFrameName_, Util.isDebug() ? 1 : 0);
    }

    public static native String getWindowID(String var0, int var1);

    public static native void requestFocus(String var0);

    public static native void moveWindow(String var0, int var1, int var2);

    public void requestInputFocus(String sWindowTitle_) {
        Linux.requestFocus(Linux.getWindowID(sWindowTitle_));
    }

    public int symlink(String sOldPath_, String sNewPath_) {
        return Linux._symlink(sOldPath_, sNewPath_);
    }

    public boolean unlink(String sPath_) {
        return Linux._unlink(sPath_) != 0;
    }

    public static boolean isLibLoaded() {
        return _bLibLoaded;
    }

    public int getPIDViaPOSIX() {
        return Linux._getpid();
    }

    public int getPIDViaProc() {
        String sPid = FileUtil.normalizeFileName("/proc/self");
        sPid = sPid.substring(6);
        int pid = Util.atoi(sPid);
        return pid;
    }

    public int getPID() {
        return this.getPIDViaPOSIX();
    }

    public int getMainJavaPID() {
        return this.getPIDViaProc();
    }

    public int getPGID(int pid_) {
        return Linux._getpgid(pid_);
    }

    public void setLocation(Frame frame, int x, int y) {
        String sTitle = frame.getTitle();
        String sWindowId = Linux.getWindowID(sTitle);
        if (sWindowId == null) {
            super.setLocation(frame, x, y);
        } else {
            Util.debug(this, (Object)("setLocation(..).sWindowId: " + sWindowId));
            Linux.moveWindow(sWindowId, x, y);
        }
    }

    public void setLocation(Dialog dialog, int x, int y) {
        String sTitle = dialog.getTitle();
        String sWindowId = Linux.getWindowID(sTitle);
        if (sWindowId == null) {
            super.setLocation(dialog, x, y);
        } else {
            Util.debug(this, (Object)("setLocation(..).sWindowId: " + sWindowId));
            Linux.moveWindow(sWindowId, x, y);
        }
    }

    static {
        _bLibLoaded = false;
        String sLibFullName = FileUtil.getPackagePath("ccl.platform");
        Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
        if (!Util.isEmpty(sLibFullName)) {
            sLibFullName = FileUtil.concatPath(sLibFullName, ".." + File.separator + ".." + File.separator + ".." + File.separator + "lib");
            Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
            if (FileUtil.existsFile(FileUtil.concatPath(sLibFullName, "libLinux.so"))) {
                sLibFullName = FileUtil.concatPath(sLibFullName, "libLinux.so");
                Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
            } else if (FileUtil.existsFile(FileUtil.concatPath(sLibFullName, "linux" + File.separator + "libLinux.so"))) {
                sLibFullName = FileUtil.concatPath(sLibFullName, "linux" + File.separator + "libLinux.so");
                Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
            } else {
                sLibFullName = "";
            }
        }
        Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
        if (Util.isEmpty(sLibFullName)) {
            try {
                sLibFullName = ClassPathUtil.getJarFileName("ccl.platform.Linux");
                Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
            }
            catch (ZipException zipException) {
                Util.printlnErr("ccl.platform.Linux.<static>.zipException: " + zipException);
                sLibFullName = null;
            }
            catch (IOException pIOException) {
                Util.printlnErr("ccl.platform.Linux.<static>.pIOException: " + pIOException);
                sLibFullName = null;
            }
            if (!Util.isEmpty(sLibFullName)) {
                String sLibDirectory = new File(sLibFullName).getParent();
                sLibFullName = FileUtil.concatPath(sLibDirectory, "libLinux.so");
                Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
                if (!FileUtil.existsFile(sLibFullName)) {
                    sLibFullName = FileUtil.concatPath(sLibDirectory, "linux" + File.separator + "libLinux.so");
                    Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
                    if (!FileUtil.existsFile(sLibFullName)) {
                        sLibFullName = "";
                    }
                }
            }
        }
        Util.debug("ccl.platform.Linux.<static>.sLibFullName: " + sLibFullName);
        if (Util.isEmpty(sLibFullName)) {
            Util.printlnErr("libLinux.so not found in ccl.platform.Linux!\nPut libLinux.so in the same directory where ccl.jar is,\nor underneath a linux directory.");
        } else {
            Runtime.getRuntime().load(FileUtil.getAbsoluteFileName(sLibFullName));
            _bLibLoaded = true;
        }
        Util.debug("ccl.platform.Linux.<static>._bLibLoaded: " + _bLibLoaded);
    }
}

