/*

Copyright (c) 1993  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

---
The above copyright notice was inserted for the 
Window_With_Name(dpy, top, name)
method which is copied from the xwininfo sources.
Chr. Clemens Lee
*/
#include <X11/Xlib.h>
#include <stdio.h>
#include <unistd.h>
#include "ccl_platform_Linux.h"

Window Window_With_Name();
int startsWith( char* s, char* with );
static char *window_id_format = "0x%lx";

/*
 * Class:     ccl_platform_Linux
 * Method:    _symlink
 * Signature: (Ljava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_ccl_platform_Linux__1symlink
  (JNIEnv *env, jclass thisClass, jstring jstrOldPath, jstring jstrNewPath)
{
 	 /*printf( "symlink" );
		fflush( stdout );*/

	 const char* utf_string_old_path;
	 const char* utf_string_new_path;
	 jboolean isCopyOldPath;
	 jboolean isCopyNewPath;
	 int retVal;
	 jint jretVal;

	 utf_string_old_path = (*env)->GetStringUTFChars( env, jstrOldPath, &isCopyOldPath );
	 utf_string_new_path = (*env)->GetStringUTFChars( env, jstrNewPath, &isCopyNewPath );

	 retVal = symlink( utf_string_old_path, utf_string_new_path );

	 if ( isCopyOldPath == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrOldPath, utf_string_old_path );
	 }
	 if ( isCopyNewPath == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrNewPath, utf_string_new_path );
	 }

	 jretVal = (jint)retVal;

	 return jretVal;
}

/*
 * Class:     ccl_platform_Linux
 * Method:    _unlink
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_ccl_platform_Linux__1unlink
  (JNIEnv *env, jclass thisClass, jstring jstrPath)
{
	 const char* utf_string_path;
	 jboolean isCopyPath;
	 int retVal;
	 jint jretVal;

	 utf_string_path = (*env)->GetStringUTFChars( env, jstrPath, &isCopyPath );

	 retVal = unlink( utf_string_path );

	 if ( isCopyPath == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrPath, utf_string_path );
	 }

	 jretVal = (jint)retVal;

	 return jretVal;
}

/*
 * Class:     ccl_platform_Linux
 * Method:    requestFocus
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_ccl_platform_Linux_requestFocus
	 (JNIEnv *env, jclass thisClass, jstring jstrFrameID ) 
{
	 const char* utf_string;
	 jboolean isCopy;
	 XID id;
	 Window window;
	 Display *dpy;

	 utf_string = (*env)->GetStringUTFChars( env, jstrFrameID, &isCopy );

	 if ( sscanf(utf_string, "0x%lx", &id) == 1) {
		  window = (Window)id;
	 } else {
		  if ( isCopy == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrFrameID, utf_string );
		  }

		  return;
	 }
	 //printf( "Got window: 0x%lx\n", window );
	 //fflush( stdout );

	 dpy = XOpenDisplay( NULL );
	 if ( dpy == NULL ) {
		  if ( isCopy == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrFrameID, utf_string );
		  }

		  return;
	 }
	 //printf( "Got display!\n" );
	 //fflush( stdout );
	 XMapRaised(dpy, window);
	 XSetInputFocus(dpy, window, 0, 0);
	 XSync(dpy, True);
	 (void) XCloseDisplay(dpy);

	 if ( isCopy == JNI_TRUE ) {
		  (*env)->ReleaseStringUTFChars( env, jstrFrameID, utf_string );
	 }
}

/*
 * Class:     ccl_platform_Linux
 * Method:    requestFocus
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_ccl_platform_Linux_moveWindow
	 (JNIEnv *env, jclass thisClass, jstring jstrFrameID, jint x, jint y ) 
{
	 const char* utf_string;
	 jboolean isCopy;
	 XID id;
	 Window window;
	 Display *dpy;

	 utf_string = (*env)->GetStringUTFChars( env, jstrFrameID, &isCopy );

	 if ( sscanf(utf_string, "0x%lx", &id) == 1) {
		  window = (Window)id;
	 } else {
		  if ( isCopy == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrFrameID, utf_string );
		  }

		  return;
	 }
	 //printf( "Got window: 0x%lx\n", window );
	 //fflush( stdout );

	 dpy = XOpenDisplay( NULL );
	 if ( dpy == NULL ) {
		  if ( isCopy == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrFrameID, utf_string );
		  }

		  return;
	 }
	 //printf( "Got display!\n" );
	 //fflush( stdout );

	 // move
	 //printf( "Moving window\n" );
	 XMoveWindow( dpy, window, x, y );

	 XSync(dpy, True);
	 (void) XCloseDisplay(dpy);

	 if ( isCopy == JNI_TRUE ) {
		  (*env)->ReleaseStringUTFChars( env, jstrFrameID, utf_string );
	 }  
}

JNIEXPORT jstring JNICALL 
Java_ccl_platform_Linux_getWindowID( JNIEnv* env, jclass thisClass, jstring jstrFrameName, jint debug ) {
	 Display *dpy;
	 int screen;
	 const char* utf_string;
	 jboolean isCopy;
	 Window window = 0;
	 char sRetVal[12];
	 const char* sNull = "";

	 /* Setip Display and Screen */
	 dpy = XOpenDisplay( NULL );
	 if ( dpy == NULL ) {
		  if ( debug == 1 ) {
				fprintf( stderr, "Unable to open display!\n" );
		  }

		  return (*env)->NewStringUTF( env, sNull );
	 }

	 screen = DefaultScreen( dpy );
	 
	 /* Select Window */
	 utf_string = (*env)->GetStringUTFChars( env, jstrFrameName, &isCopy );
	 window = Window_With_Name( dpy, RootWindow( dpy, screen ), utf_string );
	 if ( !window ) {
		  if ( debug == 1 ) {
				fprintf( stderr, "No window with name '%s' found!\n", utf_string );
		  }

		  if ( isCopy == JNI_TRUE ) {
				(*env)->ReleaseStringUTFChars( env, jstrFrameName, utf_string );
		  }

		  return (*env)->NewStringUTF( env, sNull );
	 }

    sprintf( sRetVal, window_id_format, window);
    //printf( "%s", sRetVal );
	 //fflush( stdout );

	 
	 if ( isCopy == JNI_TRUE ) {
		  (*env)->ReleaseStringUTFChars( env, jstrFrameName, utf_string );
	 }

	 return (*env)->NewStringUTF( env, sRetVal );
}

/*
 * Window_With_Name: routine to locate a window with a given name prefix on a display.
 *                   If no window with the given name is found, 0 is returned.
 *                   If more than one window has the given name, the first
 *                   one found will be returned.  Only top and its subwindows
 *                   are looked at.  Normally, top should be the RootWindow.
 */
Window Window_With_Name(dpy, top, name)
     Display *dpy;
     Window top;
     char *name;
{
	Window *children, dummy;
	unsigned int nchildren;
	int i;
	Window w=0;
	char *window_name;

	if (XFetchName(dpy, top, &window_name) && startsWith(window_name, name)) {
		 return(top);
	}
	/*if (XFetchName(dpy, top, &window_name) && !strcmp(window_name, name))
	  return(top);*/
	/*fprintf( stderr, "window_name: '%s'\n", window_name );*/

	if (!XQueryTree(dpy, top, &dummy, &dummy, &children, &nchildren))
	  return(0);

	for (i=0; i<nchildren; i++) {
		w = Window_With_Name(dpy, children[i], name);
		if (w)
		  break;
	}
	if (children) XFree ((char *)children);
	return(w);
}

int startsWith( char* s, char* with ) {
	 if ( s == with ) {
		  return -1;
	 }

	 for(;;) {
		  if ( *with == 0 ) {
				return -1;
		  }
		  if ( *s != *with ) {
				return 0;
		  }
		  s++;
		  with++;
	 }
}

/*
 * Class:     ccl_platform_Linux
 * Method:    _getpid
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_ccl_platform_Linux__1getpid
  (JNIEnv* env, jclass thisClass)
{
  return (jint)getpid();
}


/*
 * Class:     ccl_platform_Linux
 * Method:    _getpgid
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_ccl_platform_Linux__1getpgid
  (JNIEnv* env, jclass thisClass, jint jintPid)
{
  return (jint)getpgid( (pid_t)jintPid );
}




