/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.Util;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

/**
 * A tree note that offers more sophisticated add feature.
 *
 * @version  $Id: CCLTreeNode.java,v 1.8 2002/10/06 16:41:28 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class CCLTreeNode extends DefaultMutableTreeNode 
{
    public CCLTreeNode() 
    {
        super("");
    }
    
    public CCLTreeNode(Object oUser_) 
    {
        super(oUser_);
    }
    
    public CCLTreeNode(String sPath_, char cDelimiter_) 
    {
        this(Util.stringToLines(sPath_, cDelimiter_));
    }
    
    public CCLTreeNode(Vector vPathElements_) 
    {
        super();
        Util.panicIf(vPathElements_ == null ||
                     vPathElements_.size() < 1);
        String sName = (String) vPathElements_.elementAt(0);
        setUserObject(sName);
        vPathElements_.removeElementAt(0);
        
        add(vPathElements_);
    }
    
    public CCLTreeNode get(String sFullName_, char cDelimiter_) 
    {
        return get(Util.stringToLines(sFullName_, cDelimiter_));
    }
    
    public CCLTreeNode get(Vector vNodeNames_) 
    {
        if (vNodeNames_.size() == 0) 
        {
            return this;
        }
        
        String sName = (String) vNodeNames_.elementAt(0);
        
        for(int child = 0; child < getChildCount(); child++) 
        {
            CCLTreeNode tnNextChild = (CCLTreeNode) getChildAt(child);
            if (sName.equals(tnNextChild.toString())) 
            {
                Vector vChild = (Vector) vNodeNames_.clone();
                vChild.removeElementAt(0);
                
                return tnNextChild.get(vChild);
            }
        }
        
        return null;
    }
    
    public String getName(char cSeparator_) 
    {
        if (isRoot()) 
        {
            return new String(toString());
        }
        if (((CCLTreeNode) getParent()).isRoot()) 
        {
            return new String(toString());
        }
        
        return ((CCLTreeNode) getParent()).getName(cSeparator_) + cSeparator_ +
               toString();
    }
    
    public void add(String sPath_, char cDelimiter_) 
    {
        add(Util.stringToLines(sPath_, cDelimiter_));
    }
    
    public void add(Vector vChild_) 
    {
        if (vChild_ == null || vChild_.size() == 0) 
        {
            return;
        }
        String sChild = (String) vChild_.elementAt(0);
        int childrenCount = getChildCount();
        for(int child = 0; child < childrenCount; child++) 
        {
            CCLTreeNode tnNextChild = (CCLTreeNode) getChildAt(child);
            if (sChild.equals(tnNextChild.toString())) 
            {
                vChild_.removeElementAt(0);
                tnNextChild.add(vChild_);
                
                return;
            }
            else if (sChild.compareTo(tnNextChild.toString()) < 0) 
            {
                insert(new CCLTreeNode(vChild_), child);
                
                return;
            }
        }
        add(new CCLTreeNode(vChild_));
    }
    
    public Object clone() 
    {
        CCLTreeNode tnClone = new CCLTreeNode(new String(toString()));
        for( int child = 0; child < getChildCount(); child++ ) 
        {
            TreeNode tnNextChild = getChildAt(child);
            tnClone.add
                   ( (MutableTreeNode) ((CCLTreeNode) tnNextChild).clone() );
        }
        
        return tnClone;
    }
    
    public String toString( char cSeparator_ ) 
    {
        Object[] aoNode = this.getPath();
        String sRetVal = aoNode[ 0 ].toString();
        int index = 1;

        while( index < aoNode.length ) 
        {
            sRetVal += "." + aoNode[ index ];
            index++;
        }

        return sRetVal;
    }
}
