/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing.test;

import ccl.swing.SwingUtil;
import ccl.swing.DateField;
import ccl.util.Test;
import ccl.util.Util;
import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

/**
 * @version  $Id: DateFieldTest.java,v 1.6 2003/10/18 07:53:17 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class DateFieldTest extends Test 
{
    private void _setFocus( JComponent component_ ) 
{
        component_.requestFocus();
        Util.sleep( 1 );
    }

    private void _testIncDec( DateField pDateField_,
                              String sInputDate_, 
                              boolean bUp_,
                              int position_,
                              String sResultDate_ )
    {
        pDateField_.setText( sInputDate_ );

        pDateField_.requestFocus();
        Util.sleep( 1 );
        
        _setFocus( pDateField_ );
        
        pDateField_.requestFocus();
        Util.sleep( 1 );

        pDateField_.setCaretPosition( position_ );
        Util.sleep( 1 );

        int keyEvent = KeyEvent.VK_DOWN;
        if ( bUp_ ) 
{
            keyEvent = KeyEvent.VK_UP;
        }

        SwingUtil.dispatchKeyEvent( pDateField_,
                                    keyEvent );
        Util.sleep( 1 );
        bugIf( !pDateField_.getText().equals
               ( sResultDate_ ),
               "Increasing (" + bUp_ + ") " +
               sInputDate_ + " at " + position_ +" did not "+
               "result in " + sResultDate_ + " but " +
               pDateField_.getText() + "." );
    }

    public DateFieldTest() 
{
        super();
    }
    
    public DateFieldTest(Test pTest_) 
{
        super(pTest_);
    }

    protected void _doIt() 
    {
        DateField dateField = new DateField( "CET" );

        JFrame frmMain = new JFrame( "DateField Test" );
        /*frmMain.addWindowListener( new WindowAdapter() {
            public void windowClosing( WindowEvent event_ ) 
            {
                System.exit( 0 );
            }
            } );*/
        
        DateField pDateField = new DateField( "CET" );

        frmMain.getContentPane().setLayout( new BorderLayout() );
        frmMain.getContentPane().add( pDateField, BorderLayout.CENTER );
        JButton btnDummy = new JButton( "Dummy" );
        frmMain.getContentPane().add( btnDummy, BorderLayout.EAST );

        frmMain.setSize( 200, 60 );
        frmMain.pack();
        frmMain.setVisible( true );
        frmMain.setSize( 200, 60 );
        SwingUtil.centerComponent( frmMain );
        Thread.yield();

        // Down 1999-0_1_-01 -> 1999-0_9_-01
        {
            pDateField.setText( "1999-01-01" );

            pDateField.requestFocus();
            Util.sleep( 1 );

            _setFocus( pDateField );

            pDateField.requestFocus();
            Util.sleep( 1 );

            pDateField.setCaretPosition( 6 );
            Util.sleep( 1 );

            SwingUtil.dispatchKeyEvent( pDateField,
                                        KeyEvent.VK_DOWN );
            Util.sleep( 1 );
            bugIf( !pDateField.getText().equals
                   ( "1999-09-01" ),
                   "Decrease to 1999-09-01 did not work." );
        }

        // setText( "" ); test
        pDateField.setToday();
        pDateField.setText( "" );
        bugIf( !pDateField.getText().equals( "" ), "Date not set to \"\"!" );

        // Down 1999-_1_0-01 -> 1999-_1_0-01
        _testIncDec( pDateField, "1999-10-01", false, 5, "1999-10-01" );

        // Up 1999-_1_0-01 -> 1999-_1_0-01
        _testIncDec( pDateField, "1999-10-01", true, 5, "1999-10-01" );

        // Down 1999-08-0_1_ -> 1999-08-0_9_
        _testIncDec( pDateField, "1999-08-01", false, 9, "1999-08-09" );

        // Up 1999-0_9_-01 -> 1999-0_1_-01
        _testIncDec( pDateField, "1999-09-01", true, 6, "1999-01-01" );

        // Up 1999-07-0_9_ -> 1999-07-0_1_
        _testIncDec( pDateField, "1999-07-09", true, 9, "1999-07-01" );


        // Down 1999-1_0_-01 -> 1999-1_2_-01
        _testIncDec( pDateField, "1999-10-01", false, 6, "1999-12-01" );

        // Down 1999-01-3_0_ -> 1999-01-3_1_
        _testIncDec( pDateField, "1999-01-30", false, 9, "1999-01-31" );

        // Up 1999-01-_3_0 -> 1999-01-_1_0
        _testIncDec( pDateField, "1999-01-30", true, 8, "1999-01-10" );

        // Up 1999-01-_3_0 -> 1999-01-_1_0
        _testIncDec( pDateField, "1999-01-30", true, 8, "1999-01-10" );

        // Down 1999-01-_1_0 -> 1999-01-_3_0
        _testIncDec( pDateField, "1999-01-10", false, 8, "1999-01-30" );

        // Down 1999-02-_1_0 -> 1999-02-_1_0
        _testIncDec( pDateField, "1999-02-10", false, 8, "1999-02-10" );

        // Down 1999-1_1_-01 -> 1999-1_0_-01
        {
            pDateField.setText( "1999-11-01" );

            pDateField.requestFocus();
            Util.sleep( 1 );

            _setFocus( pDateField );

            pDateField.requestFocus();
            Util.sleep( 1 );

            pDateField.setCaretPosition( 6 );
            Util.sleep( 1 );

            SwingUtil.dispatchKeyEvent( pDateField,
                                        KeyEvent.VK_DOWN );
            Util.sleep( 1 );
            bugIf( !pDateField.getText().equals
                   ( "1999-10-01" ),
                   "Decrease to 1999-10-01 did not work." );
        }

        // Up 1999-02-_2_1 -> 1999-02-01
        {
            pDateField.setText( "1999-02-21" );

            pDateField.requestFocus();
            Util.sleep( 1 );

            _setFocus( pDateField );

            pDateField.requestFocus();
            Util.sleep( 1 );

            pDateField.setCaretPosition( 8 );
            Util.sleep( 1 );

            SwingUtil.dispatchKeyEvent( pDateField,
                                        KeyEvent.VK_UP );
            Util.sleep( 1 );
            bugIf( !pDateField.getText().equals
                   ( "1999-02-01" ),
                   "Increase to 1999-02-01 did not work." );
        }

        // Down 1999-_1_2-31 should not change a single bit.
        {
            pDateField.setText( "1999-12-31" );
            bugIf( !pDateField.getText().equals
                   ( "1999-12-31" ),
                   "Field couldn't be set (1999-12-31)!" );

            pDateField.requestFocus();
            Util.sleep( 1 );

            _setFocus( pDateField );

            pDateField.requestFocus();
            Util.sleep( 1 );

            pDateField.setCaretPosition( 5 );
            Util.sleep( 1 );

            SwingUtil.dispatchKeyEvent( pDateField,
                                        KeyEvent.VK_DOWN );
            Util.sleep( 1 );
            bugIf( !pDateField.getText().equals
                   ( "1999-12-31" ),
                   "Decrease did not work. " +
                   "It should not have changed a single bit." );
        }
        
        // Down on 1999-_1_2-01 should result in
        // 1999-_0_2-01! Down again should result in previous
        // value.
        {
            pDateField.setText( "1999-12-01" );
            bugIf( !pDateField.getText().equals
                   ( "1999-12-01" ),
                   "Field couldn't be set (1999-12-01)!" );

            pDateField.requestFocus();
            Util.sleep( 1 );

            _setFocus( pDateField );

            pDateField.requestFocus();
            Util.sleep( 1 );

            pDateField.setCaretPosition( 5 );
            Util.sleep( 1 );

            SwingUtil.dispatchKeyEvent( pDateField,
                                        KeyEvent.VK_DOWN );
            Util.sleep( 1 );
            bugIf( !pDateField.getText().equals
                   ( "1999-02-01" ),
                   "Decrease did not work. " +
                   "It should result in '1999-02-01'." );

            SwingUtil.dispatchKeyEvent( pDateField,
                                        KeyEvent.VK_DOWN );
            Util.sleep( 1 );
            bugIf( !pDateField.getText().equals
                   ( "1999-12-01" ),
                   "2. Decrease did not work. " +
                   "It should result in '1999-12-01'." );
        }

        // up on 1999-_1_2-01 should result in
        // 1999-_0_2-01!
        {
            pDateField.setText( "1999-12-01" );
            bugIf( !pDateField.getText().equals
                   ( "1999-12-01" ),
                   "Field couldn't be set (1999-12-01)!" );

            pDateField.requestFocus();
            Util.sleep( 1 );

            _setFocus( pDateField );

            pDateField.requestFocus();
            Util.sleep( 1 );

            pDateField.setCaretPosition( 5 );
            Util.sleep( 1 );

            SwingUtil.dispatchKeyEvent( pDateField,
                                        KeyEvent.VK_UP );
            Util.sleep( 1 );
            bugIf( !pDateField.getText().equals
                   ( "1999-02-01" ),
                   "Increase did not work. " +
                   "It should result in '1999-02-01'." );
        }

        // Type a wrong key and expect current date to be set.
        // Cursor should be at position 9 afterwards.
        {
            pDateField.clear();
            bugIf( pDateField.getText().length() != 0,
                   "Text wasn't cleared!" );
            Util.sleep( 1 );

            // set focus
            pDateField.requestFocus();
            Util.sleep( 1 );

            SwingUtil.dispatchKeyEvent( pDateField, 'e' ); 
            Util.sleep( 1 );

            bugIf( pDateField.getText().length() != 10,
                   "Wrong key didn't set current date!" );

            bugIf( pDateField.getCaretPosition() != 9,
                   "Wrong caret/cursor position (should be 9): " +
                   pDateField.getCaretPosition() );
        }


        pDateField.setText( "1999-12-02" );

        Util.sleep( 1 );

        bugIf( pDateField.getText().length() != 10,
               "No init date set in field!" );

        // set focus
        pDateField.requestFocus();
        Util.sleep( 1 );

        pDateField.setCaretPosition( 0 );

        // input 1234-0
        SwingUtil.dispatchKeyEvent( pDateField, '1' );
        Util.sleep( 1 );

        SwingUtil.dispatchKeyEvent( pDateField, '2' );
        Util.sleep( 1 );

        SwingUtil.dispatchKeyEvent( pDateField, '3' );
        Util.sleep( 1 );

        SwingUtil.dispatchKeyEvent( pDateField, '4' );
        Util.sleep( 1 );

        SwingUtil.dispatchKeyEvent( pDateField, '0' );
        Util.sleep( 1 );

        bugIf( !pDateField.getText().startsWith( "1234-0" ),
               "Date did not start with '1234-0' but is '" +
               pDateField.getText() + "'!" );    

        String sDate = "1998-12-22";
        pDateField.setText( sDate );
        bugIf( !pDateField.isDateValid(),
               "Date " + sDate + " should be valid!" );

        sDate = "1999-11-31";
        bugIf( Util.isDateValid( sDate ),
               "Date " + sDate + " shouldn't be valid!" );

        SwingUtil.dispatchKeyEvent( pDateField, KeyEvent.VK_BACK_SPACE );
        Util.sleep( 1 );
        bugIf( !pDateField.getText().equals( "" ), 
               "Date field wasn't deleted!" );

        frmMain.setVisible( false );
        frmMain.dispose();
    }

    public static void main(String[] asArg_)  
    {
        Test pTest = (Test)(new DateFieldTest());
        Test.printResult(pTest);

        System.exit(0);
    }
}
