/*
 * File: Comparable.java
 *
 * Originally written by Doug Lea and released into the public domain.
 * Thanks for the assistance and support of Sun Microsystems Labs, Agorics
 * Inc, Loral, and everyone contributing, testing, and using this code.
 *
 * History:
 * Date       Who                What
 * 24Sep95    dl@cs.oswego.edu   Create from collections.java working file
 * 1999-07-15 clemens@kclee.com  Renamed from Comparator to Comparable
 */

package ccl.util;

/**
 * Comparable is an interface for any class possessing an element
 * comparison method.
 * @author Doug Lea
 * @version 0.93
 *
 * <P> For an introduction to this package see
 * <A HREF="index.html"> Overview </A>.
 */
public interface Comparable 
{
    /**
     * Compare two Objects with respect to ordering. Typical
     * implementations first cast their arguments to particular
     * types in order to perform comparison
     *
     * @param    oFirst_    first argument
     * @param    oSecond_   second argument
     * @return              a negative number if fst is less than snd; a
     *                      positive number if fst is greater than snd; else 0
     */
    public int compare( Object oFirst_, Object oSecond_ );
}
