/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util.test;

import ccl.util.OutputErrorStreamManager;
import ccl.util.Test;
import ccl.util.Util;
import java.util.Observable;
import java.util.Observer;

/**
 * Insert your test code into the _doIt() method and
 * test bugs with 'bugIf( boolean expression );' or
 * 'bugIf( boolean expression, "comment about what went wrong" );'.
 * Then just invoke the main routine.
 *
 * @version $Id: OutputErrorStreamManagerTest.java,v 1.5 2003/05/01 16:44:48 clemens Exp clemens $
 * @author  Chr. Clemens Lee (clemens@kclee.com)
 */
public class OutputErrorStreamManagerTest extends    Test
                                          implements Observer
{
    private int _updates = 0;

    public OutputErrorStreamManagerTest() 
    {
        super();
    }

    public OutputErrorStreamManagerTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    /**
     * This is the main method where the action takes place.
     *
     * @exception   Exception   just to catch every possible bug.
     */
    protected void _doIt()
        throws Exception
    {
        OutputErrorStreamManager outErrManager = new OutputErrorStreamManager();

        _updates = 0;
        outErrManager.install     ();
        outErrManager.setVisible  ( false );
        outErrManager.setAutoClear( false );
        outErrManager.addObserver ( this  );

        byte[] abTest = new byte[] {   (byte) 't'
                                     , (byte) 'e'
                                     , (byte) 's'
                                     , (byte) 't' };
        System.out.write( abTest, 0, 4 );
        outErrManager.setVisible( true );
        bugIf( !outErrManager.getStreamsBuffer()
                             .equals( "test" )
               , "Catched std stream content: --->" 
                 + outErrManager.getStreamsBuffer()
                 + "<---" );
        outErrManager.clearStreamsBuffer();

        bugIf( !(System.out instanceof OutputErrorStreamManager.OutputErrorStream )
               , "System.out is not an instance of OutputErrorStream: "
                 + System.out.getClass().getName() );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        System.out.print( true );
        outErrManager.setVisible( true );
        bugIf( !outErrManager.getStreamsBuffer()
                             .equals( "true" )
               , "Catched std stream content: --->" 
                 + outErrManager.getStreamsBuffer()
                 + "<---" );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        System.out.print( "trala" );
        outErrManager.setVisible( true );
        bugIf( !outErrManager.getStreamsBuffer()
                             .equals( "trala" )
               , "Catched std stream content: --->" 
                 + outErrManager.getStreamsBuffer()
                 + "<---" );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        Util.print( "test" );
        System.out.write( 'a' );
        outErrManager.setVisible( true );
        bugIf( !outErrManager.getStreamsBuffer()
                             .equals( "testa" )
               , "Catched std stream content: " 
                 + outErrManager.getStreamsBuffer() );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        Util.print   ( "out" );
        Util.printErr( "err" );
        outErrManager.setVisible( true );
        bugIf( !outErrManager.getStreamsBuffer()
                             .equals( "outerr" )
               , "Catched std stream content: <---" 
                 + outErrManager.getStreamsBuffer()
                 + "<---" );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        _updates = 0;
        System.out.print( "notify" );
        System.out.flush();
        String sLastOutput = _sLastOutErr;
        outErrManager.setVisible( true );
        bugIf( _updates <= 0, "No updates received" );
        bugIf( !String.valueOf( sLastOutput ).equals( "notify" )
               , "Last output message: --->"
                 + sLastOutput
                 + "<---" );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        _updates = 0;
        Util.print( "notify2" );
        sLastOutput = _sLastOutErr;
        outErrManager.setVisible( true );
        bugIf( _updates <= 0, "No updates received" );
        bugIf( !String.valueOf( sLastOutput ).equals( "notify2" )
               , "Last output message: --->"
                 + sLastOutput
                 + "<---" );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        outErrManager.setAutoClear( false );
        System.out.print( "bla" );
        System.out.print( "bla" );
        System.out.flush();
        outErrManager.setVisible( true );
        bugIf( !outErrManager.getStreamsBuffer().equals( "blabla" ) );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        outErrManager.setAutoClear( true );
        Util.print( "bla" );
        Util.print( "bla" );
        sLastOutput = _sLastOutErr;
        outErrManager.setVisible( true );
        bugIf( !sLastOutput.equals( "bla" )
               , "Last output message: --->"
                 + sLastOutput
                 + "<---" );
        outErrManager.setVisible( false );
        outErrManager.clearStreamsBuffer();

        outErrManager.deinstall();
    }

    private String _sLastOutErr = null;

    public void update( Observable observable_, Object arg_ ) 
    {
        _updates++;
        _sLastOutErr = String.valueOf( arg_ );
    }

    public static void main( String[] asArg_ ) 
    {
        Test pTest = (Test) (new OutputErrorStreamManagerTest());
        pTest.setVerbose( true );
        pTest.run();
        printResult( pTest );

        System.exit( 0 );
    }
}
