/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util.test;

import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

/**
 * Test cases for ccl.util.Util.stringToLines(..) and
 * concat(..) methods.
 * 
 * @version $Id: SToLAndConcatTest.java,v 1.9 2003/05/01 16:44:50 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>
 */
public class SToLAndConcatTest extends Test 
{
    /**
     * A text file appeared which adds another line with value null to the
     * vector created during conversion.
     *
     * @exception   Exception   when reading test file failed.
     */
    private void _checkToManyLinesBug()
        throws Exception
    {
        URL url = this.getClass().getResource( "string2lines_test2.txt" );
        String sTest = FileUtil.readFile( url );
        Assert( sTest.length() == 2
                , "Test file has text length of " 
                + sTest.length()
                + " instead of 2." );

        InputStream stream = FileUtil.getResourceAsStream( this, "string2lines_test2.txt" );
        String sContent2 = FileUtil.readStream( stream );
        bugIf( sContent2 == null );
        Assert( sContent2.length() == 2
                , "Test resource has text length of " 
                + sContent2.length()
                + " instead of 2." );

        String sContent = FileUtil.getResourceAsString( this, "string2lines_test2.txt" );
        bugIf( sContent == null );
        Assert( sContent.length() == 2
                , "Test resource has text length of " 
                + sContent.length()
                + " instead of 2." );

        url = this.getClass().getResource( "string2lines_test.txt" );
        sTest = FileUtil.readFile( url );
        bugIf( sTest == null );
        Vector vTest = Util.stringToLines( sTest );
        Assert( vTest.size() == 18, "Vector size should be 18 but is " + vTest.size() );

        sTest = FileUtil.getResourceAsString( this, "string2lines_test3.txt" );
        bugIf( sTest == null );
        vTest = Util.stringToLines( sTest );
        Assert( vTest.size() == 1, "Vector size should be 1 but is " + vTest.size() );

        sTest = FileUtil.getResourceAsString( this, "string2lines_test.txt" );
        bugIf( sTest == null );
        vTest = Util.stringToLines( sTest );
        Assert( vTest.size() == 18, "Vector size should be 18 but is " + vTest.size() );
    }

    public SToLAndConcatTest() 
    {
        super();
    }

    public SToLAndConcatTest(Test pTest_) 
    {
        super(pTest_);
    }

    /**
     * This method executes the tests that check if conversion between strings and
     * vectors work as expected.
     *
     * @exception   Exception   in case anything goes wrong.
     */
    protected void _doIt() 
        throws Exception
    {
        _checkToManyLinesBug();

        String[] asTest = new String[8];
        Vector[] avTest = new Vector[8];
        int[] aTestSize = new int[8];
        int[] aControlSize = new int[8];

        asTest[0] = "H:\\eigen\\src\\JAVA\\jamacs\\Jamacs.prj\nH:\\eigen\\go\\Jactor\\Collector.prj;H:\\eigen\\SOCCER\\semifinal\\Semifinal.prj;\nj:\\softwarehelp\\language-spec.hlp";
        asTest[1] = asTest[0] + "\n";
        asTest[2] = asTest[1] + "\n";
        asTest[3] = "";
        asTest[4] = new String();
        asTest[5] = " ";
        asTest[6] = "ganz Normaler Text";
        asTest[7] = null;

        aControlSize[0] = 3;
        aControlSize[1] = 3;
        aControlSize[2] = 4;
        aControlSize[3] = 0;
        aControlSize[4] = 0;
        aControlSize[5] = 1;
        aControlSize[6] = 1;
        aControlSize[7] = 0;

        String sErg1 = "H:\\eigen\\src\\JAVA\\jamacs\\Jamacs.prjH:\\eigen\\go\\Jactor\\Collector.prj;H:\\eigen\\SOCCER\\semifinal\\Semifinal.prj;j:\\softwarehelp\\language-spec.hlp";

        for(int test = 0; test < asTest.length; test++) 
        {
            avTest[test] = Util.stringToLines(asTest[test]);
            aTestSize[test] = avTest[test].size();
        }
        for(int test = 0; test < asTest.length; test++) 
        {
            bugIf(aTestSize[test] != aControlSize[test]);
        }
        // Nr. 9
        if (bugIf(!Util.concat(avTest[1], "\n").equals(asTest[0]))) 
        {
            Util.println("Test0: " + avTest[0]);
            Util.println("Test1: " + avTest[1]);
            Util.println("Concat Test0: " + Util.concat(avTest[0], "\n"));
            Util.println("asTest[1]: " + asTest[1]);
        }
        // Nr. 10
        if (bugIf(!Util.concat(avTest[2]).equals(Util.concat(avTest[0])))) 
        {
            Util.println("Test0: " + avTest[0]);
            Util.println("Test1: " + avTest[1]);
            Util.println("Test2: " + avTest[2]);
            Util.println("Concat Test0: " + Util.concat(avTest[0]) + "*");
            Util.println("Concat Test2: " + Util.concat(avTest[2]) + "*");
            Util.println("asTest0: " + asTest[0] + "*");
        }
        bugIf(!Util.concat(avTest[1]).equals(sErg1));
        bugIf(!Util.concat(avTest[0]).equals(sErg1));
        bugIf(!sErg1.equals(Util.concat(avTest[2])));

        // Test Nr. 14, concat
        bugIf(!Util.concat(null).equals(""));
        // Null String Test interesse halber
        bugIf(!((new String()).equals("")));
        bugIf(!Util.concat(new Vector(), (String) null).equals(""));
        // Nr. 17
        Vector vTest = new Vector();
        vTest.addElement((Object) "kjh");
        vTest.addElement((Object) "kjh");
        bugIf(!Util.concat(vTest, (String) null).equals("kjhkjh"));
    }

    public static void main(String[] args) 
    {
        Test pTest = (Test) (new SToLAndConcatTest());
        pTest.setTiming( true );
        pTest.setVerbose( true );
        pTest.run();
        pTest.printResult();

        System.exit( 0 );
    }
}
