/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package junit.framework;

import java.util.Vector;

/**
 * This class is a fake for JUnit test suite classes. It redirects all your test code to use the
 * test class from the ccl.util.Test class.
 *
 * @author  Chr. Clemens Lee
 * @version $Id: TestSuite.java,v 1.5 2003/11/23 09:13:57 clemens Exp clemens $
 */
public class TestSuite implements Test
{
    private Class _testClass = null;
    private Vector _subTests = new Vector();

    /**
     * Default constructor expected in Test.
     */
    public TestSuite() 
    {
        super();
    }

    /**
     * Standard constructor expected in JUnit TestCase.
     */
    public TestSuite( String testName ) 
    {
        super();
    }

    /**
     * Constructor expected by objects who want to 
     * create JUnit test suite objects.
     */
    public TestSuite( Class testClass_ )
    {
    	super();

        _testClass = testClass_;
    }

    /**
     * Simulates to add a test case object to this suite, but there is
     * no functionality implemented yet.
     */
    public void addTest( TestCase testCase )
    {
        _subTests.addElement( testCase );
    }

    /**
     * Simulates to add a test suite object to this suite, but there is
     * no functionality implemented yet.
     */
    public void addTestSuite( Class classTestSuite )
    {
        _subTests.addElement( classTestSuite );
    }

    /**
     * Simulates to add a test of test suite object to this suite, but there is
     * no functionality implemented yet.
     */
    public void addTest( Test test )
    {
        _subTests.addElement( test );
    }

    /*
      public void run( TestResult testResult )
    {
        throw new RuntimeException( getClass().getName() + ".run(TestResult) not implemented" );
    }
    */

    /**
     * Returns all sub tests.
     */
    public Vector getSubTests()
    {
        return (Vector) _subTests.clone();
    }

    /**
     * Returns the contained test class.
     */
    public Class getTestClass()
    {
        return _testClass;
    }
}
